% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asof_join.R
\name{asof_join}
\alias{asof_join}
\title{Temporal join}
\usage{
asof_join(
  left,
  right,
  tol = "0ms",
  direction = c(">=", "<=", "<"),
  key_columns = list(),
  left_prefix = NULL,
  right_prefix = NULL
)
}
\arguments{
\item{left}{The left `TimeSeriesRDD`}

\item{right}{The right `TimeSeriesRDD`}

\item{tol}{A character vector specifying a time duration (e.g., "0ns", "5ms",
"5s", "1d", etc) as the tolerance for absolute difference in timestamp values
between each record from `left` and its matching record from `right`.
By default, `tol` is "0ns", which means a record from `left` will only be
matched with a record from `right` if both contain the exact same timestamps.}

\item{direction}{Specifies the temporal direction of the join, must be one
of ">=", "<=", or "<".
If direction is ">=", then each record from `left` with timestamp `tl`
gets joined with a record from `right` having the largest/most recent
timestamp `tr` such that `tl` >= `tr` and `tl` - `tr` <= `tol` (or
equivalently, 0 <= `tl` - `tr` <= `tol`).
If direction is "<=", then each record from `left` with timestamp `tl`
gets joined with a record from `right` having the smallest/least recent
timestamp `tr` such that `tl` <= `tr` and `tr` - `tl` <= `tol` (or
equivalently, `0 <= `tr` - `tl` <= `tol`).
If direction is "<", then each record from `left` with timestamp `tl`
gets joined with a record from `right` having the smallest/least recent
timestamp `tr` such that `tr` > `tl` and `tr` - `tl` <= `tol` (or
equivalently, 0 < `tr` - `tl` <= `tol`).}

\item{key_columns}{Columns to be used as the matching key among records from
`left` and `right`: if non-empty, then in addition to matching criteria
imposed by timestamps, a record from `left` will only match one from the
`right` only if they also have equal values in all key columns.}

\item{left_prefix}{A string to prepend to all columns from `left` after the
join (usually for disambiguation purposes if `left` and `right` contain
overlapping column names).}

\item{right_prefix}{A string to prepend to all columns from `right` after the
join (usually for disambiguation purposes if `left` and `right` contain
overlapping column names).}
}
\description{
Perform left-outer join on 2 `TimeSeriesRDD`s based on inexact timestamp
matches
}
\examples{

library(sparklyr)
library(sparklyr.flint)

sc <- try_spark_connect(master = "local")
if (!is.null(sc)) {
  ts_1 <- copy_to(sc, tibble::tibble(t = seq(10), u = seq(10))) \%>\%
    from_sdf(is_sorted = TRUE, time_unit = "SECONDS", time_column = "t")
  ts_2 <- copy_to(sc, tibble::tibble(t = seq(10) + 1, v = seq(10) + 1L)) \%>\%
    from_sdf(is_sorted = TRUE, time_unit = "SECONDS", time_column = "t")
  future_left_join_ts <- asof_join(ts_1, ts_2, tol = "1s", direction = "<=")
} else {
  message("Unable to establish a Spark connection!")
}

}
\seealso{
Other Temporal join functions: 
\code{\link{asof_future_left_join}()},
\code{\link{asof_left_join}()}
}
\concept{Temporal join functions}
