% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span_hk.R
\name{span_hk}
\alias{span_hk}
\title{Huberman–Kandel Joint Mean–Variance Spanning Test (1987)}
\usage{
span_hk(R1, R2)
}
\arguments{
\item{R1}{Numeric matrix of benchmark returns, dimension \eqn{T \times K}.}

\item{R2}{Numeric matrix of test-asset returns, dimension \eqn{T \times N}.}
}
\value{
A named list with components:
\describe{
  \item{\code{pval}}{P-value for the \eqn{F}-statistic under the null.}
  \item{\code{stat}}{\eqn{F}-statistic value.}
  \item{\code{H0}}{Null hypothesis description, \code{"alpha = 0 and delta = 0"}.}
}
}
\description{
Tests the joint null \eqn{H_0:\ \alpha = 0,\ \delta = 0} that the benchmark
assets span the mean–variance frontier of the augmented (benchmark + test)
universe. Following Huberman & Kandel (1987), the statistic compares the
frontiers with and without the additional assets.
}
\details{
The test evaluates whether adding the test assets changes the efficient
frontier implied by the benchmarks. Under standard regularity conditions,
the statistic has an \eqn{F} reference with \eqn{(2N,\ 2(T-K-N))} degrees of
freedom. Finite-sample feasibility requires \eqn{T-K-N \ge 1}.
}
\examples{
set.seed(123)
R1 <- matrix(rnorm(300), 100, 3)  # benchmarks: T=100, K=3
R2 <- matrix(rnorm(200), 100, 2)  # tests:      T=100, N=2
out <- span_hk(R1, R2)
out$stat; out$pval; out$H0

}
\references{
\insertRef{HubermanKandel1987}{spantest} \cr
}
\seealso{
Other Joint Mean-Variance Spanning Tests: 
\code{\link{span_gl_ad}()}
}
\concept{Joint Mean-Variance Spanning Tests}
