% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{esc_kernel_loo_tnkde_adpt}
\alias{esc_kernel_loo_tnkde_adpt}
\title{The worker function to calculate continuous TNKDE likelihood cv (adaptive case)}
\arguments{
\item{kernel_func}{a cpp pointer function (selected with the kernel name)}

\item{edge_mat}{matrix, to find the id of each edge given two neighbours.}

\item{events}{a NumericVector indicating the nodes in the graph being events}

\item{time_events}{a NumericVector indicating the timestamp of each event}

\item{neighbour_list}{a List, giving for each node an IntegerVector with
its neighbours}

\item{v}{the actual node to consider (int)}

\item{v_time}{the time of v (double)}

\item{bws_net}{an arma::mat with the network bandwidths to consider}

\item{bws_time}{an arma::mat with the time bandwidths to consider}

\item{line_weights}{a vector with the length of the edges}

\item{depth}{the actual recursion depth}

\item{max_depth}{the maximum recursion depth}
}
\value{
a cube with the impact of the event v on each other event for
each pair of bandwidths (cube(bws_net, bws_time, events))
}
\description{
The worker function to calculate continuous TNKDE likelihood cv (INTERNAL)
}
\keyword{internal}
