% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BPS_weights}
\alias{BPS_weights}
\title{Compute the BPS weights by convex optimization}
\usage{
BPS_weights(data, priors, coords, hyperpar, K)
}
\arguments{
\item{data}{\link{list} two elements: first named \eqn{Y}, second named \eqn{X}}

\item{priors}{\link{list} priors: named \eqn{\mu_b},\eqn{V_b},\eqn{a},\eqn{b}}

\item{coords}{\link{matrix} sample coordinates for X and Y}

\item{hyperpar}{\link{list} two elemets: first named \eqn{\delta}, second named \eqn{\phi}}

\item{K}{\link{integer} number of folds}
}
\value{
\link{matrix} posterior predictive density evaluations (each columns represent a different model)
}
\description{
Compute the BPS weights by convex optimization
}
\examples{
## Generate subsets of data
n <- 100
p <- 3
X <- matrix(rnorm(n*p), nrow = n, ncol = p)
Y <- matrix(rnorm(n), nrow = n)
crd <- matrix(runif(n*2), nrow = n, ncol = 2)

## Select competitive set of values for hyperparameters
delta_seq <- c(0.1, 0.2, 0.3)
phi_seq <- c(3, 4, 5)

## Perform Bayesian Predictive Stacking within subsets
bps <- spBPS::BPS_weights(data = list(Y = Y, X = X),
                               priors = list(mu_b = matrix(rep(0, p)),
                                             V_b = diag(10, p),
                                             a = 2,
                                             b = 2), coords = crd,
                                             hyperpar = list(delta = delta_seq,
                                                             phi = phi_seq),
                                             K = 5)

}
