% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.SOMnn.R
\name{predict,SOMnn-method}
\alias{predict,SOMnn-method}
\title{predict method for S4 class \code{SOMnn}}
\usage{
\S4method{predict}{SOMnn}(object, x)
}
\arguments{
\item{object}{object of type \code{SOMnn}.}

\item{x}{\code{data.frame} with rows of data to be predicted.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{       \code{data.frame} with columns: 
               \code{winner}, \code{x}, \code{y}, the predicted probabilities
               for all categories and the prediction 
               as category index (column name \code{prediction}) and
               class label (column name \code{pred.class}).
}\if{html}{\out{</div>}}
}
\description{
Predicts categories for a table of data, based on the hexagonal som in the model.
This S4 method is a wrapper for the predict method stored in the slot \code{predict}
of a model of type SOMnn.
}
\details{
The function returns the winner neuron in \code{codes} for
each test vector in \code{x}.
\code{x} is organised as one vector per row and must have
the same number of columns (i.e. dimensions) and the identical column names
as stored in the SOMnn object.

If data have been normalised during training, the same normalisation is applied
to the unknown data to be predicted.

Probablilities are softmax normalised by default.
}
