% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soilchemistry.R
\docType{data}
\name{df_sordes}
\alias{df_sordes}
\title{Example Data Frame for adsorption, desorption, and supply parameter}
\format{
Write the following notations on the spreadsheet:
Initial_conc for Initial concentration (mg/L) of the added element, e.g., phosphorus
Equilibrium_conc for Final or equilibrium concentration (mg/L) after adsorption of the same element
Cf_Des for Final or equilibrium concentration (mg/L) after desorption of the same element
}
\usage{
df_sordes
}
\description{
User is advised to prepare the data as suggested in the example to fit adsorption or desorption data pertaining to a particular nutrient, e.g., phosphorus (as phosphate), sulphur (as sulphate), micronutrient cations or anions, silicon (as silicate), etc. in soil to the functions namely, Freundlich_A, Freundlich_D, Langmuir, and SP. However, to use these functions, researchers should carry out the adsorption-desorption study in the method described as follows: W g (e.g., 2 g) of processed soil samples are taken in a series of 50 mL centrifuge tubes (polypropylene) each containing V mL (e.g., 20 mL) 0.1 M sodium chloride solution with different levels (e.g., 10, 20, 40, 60, … mg/L) of the nutrient under consideration (e.g., P). The tubes are shaken continuously for a defined period (e.g., 24 h) using a mechanical shaker. Immediately after that, each of them is centrifuged (e.g., at 10000 rpm) for sufficient time (e.g., 10-12 min), and a certain volume (e.g., 15 mL) of clear aliquot is pipetted out and filtered through a Whatman No. 42 filter paper. Then the nutrient content (e.g., P) in the filtrate is estimated by standard procedures. The difference between the quantities of the nutrient in the bathing solution before (initial concentration) and after equilibration (equilibrium or final concentration) is taken as the amount of the nutrient adsorbed by the soil from bathing solution. For desorption study, once supernatant is removed after completion of the adsorption step, a certain volume (e.g., 15 mL) of 0.1 M sodium chloride solution is added in the same sample to reach a final volume (Vfinal). For convenience in calculation, Vfinal should be equal to V (as taken initially). Generally, soil sample with the highest level of added nutrient from the adsorption study is used in desorption experiment. With the help of mechanical shaker, the soil is re-suspended and equilibrated for 12 h. After shaking, the tubes are centrifuged (e.g., at 10000 rpm) for sufficient time (e.g., 10–12 min), and the same volume (as in the previous step, e.g., 15 mL) of clear supernatant solution is pipetted out for determination of the concentration of the nutrient. This process can be repeated multiple times depending on the objective and convenience of the researcher. The difference between equilibrium concentration at a particular desorption step and equilibrium concentration previous to that desorption step, multiplied by solution:soil ratio (e.g., 20:2) is considered as desorbed amount of the nutrient. The adsorbed amount remaining after each desorption step can be computed by subtracting the desorbed amount at a particular step from the amount of adsorbed nutrient present before that desorption step.
}
\keyword{datasets}
