% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_contact_survey.R
\name{as_contact_survey}
\alias{as_contact_survey}
\title{Check contact survey data}
\usage{
as_contact_survey(
  x,
  id_column = "part_id",
  country_column = NULL,
  year_column = NULL,
  ...,
  id.column = deprecated(),
  country.column = deprecated(),
  year.column = deprecated()
)
}
\arguments{
\item{x}{list containing
\itemize{
\item an element named 'participants', a data frame containing participant
information
\item an element named 'contacts', a data frame containing contact information
\item (optionally) an element named 'reference, a list containing information
information needed to reference the survey, in particular it can contain$a
"title", "bibtype", "author", "doi", "publisher", "note", "year"
}}

\item{id_column}{the column in both the \code{participants} and \code{contacts} data frames that links contacts to participants}

\item{country_column}{the column in the \code{participants} data frame containing the country in which the participant was queried; if NULL (default), will use "country" column if present}

\item{year_column}{the column in the \code{participants} data frame containing the year in which the participant was queried; if NULL (default), will use "year" column if present}

\item{...}{additional arguments (currently ignored)}

\item{id.column, country.column, year.column}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use the underscore versions (e.g., \code{id_column}) instead.}
}
\value{
invisibly returns a character vector of the relevant columns
}
\description{
Checks that a survey fulfills all the requirements to work with the 'contact_matrix' function
}
\examples{
data(polymod)
check(polymod)
}
