% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all.paths.R
\name{social.all.paths}
\alias{social.all.paths}
\title{All paths between two nodes}
\usage{
social.all.paths(A, start.node, end.node, max.depth = nrow(A), 
  n.pilot = 5000, n.estimate = 10000)
}
\arguments{
\item{A}{a (possibly weighted) adjacency matrix.}

\item{start.node}{the index of the vertex from which the paths will be calculated.}

\item{end.node}{the index of the vertex to which the paths will be calculated.}

\item{max.depth}{the maximum length of the paths to the returned.}

\item{n.pilot}{the number of naive paths to generate (see Roberts & Kroese, 2007).}

\item{n.estimate}{the number of paths to generate (see Roberts & Kroese, 2007).}
}
\value{
An estimate of all the unique paths between \code{start.node} and \code{end.node} as an \code{nrow(A)}xN matrix, padded with zeros.
}
\description{
Estimate all the possible paths between two nodes in a simple graph using the stochastic method described by Roberts & Kroese (2007).
}
\references{
Roberts, B. & Kroese, D.P. (2007) Estimating the number of s-t paths in a graph. Journal of Graph Algorithms and Applications 11(1), 195-214.
}
\examples{
# Using the data from Figure 1 in Roberts & Kroese (2007)
A = matrix(c(0,1,0,1,0,
             1,0,0,1,1,
             0,0,0,1,1,
             1,1,1,0,0,
             0,1,1,0,0), nrow=5)
paths = social.all.paths(A, 1, 5)

}
