% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_data}
\alias{simulate_data}
\title{Simulate social interaction datasets}
\usage{
simulate_data(
  ind = 200,
  partners = 4,
  repeats = 1,
  iterations = 100,
  B_0 = 0,
  psi = NULL,
  Valpha,
  Vepsilon = NULL,
  Vpsi = 0,
  Vx = 1,
  Ve = 0.6,
  Vxe = 0,
  r_alpha_epsilon = 0,
  r_alpha_psi = 0,
  r_epsilon_psi = 0,
  r_alpha_x = 0,
  r_psi_x = 0,
  r_epsilon_x = 0,
  fix_total_var = TRUE
)
}
\arguments{
\item{ind}{Number of individuals.}

\item{partners}{Partners per individual.}

\item{repeats}{Repeats per unique dyad.}

\item{iterations}{Number of datasets to simulate.}

\item{B_0}{Population intercept.}

\item{psi}{Population-level responsiveness (social slope).}

\item{Valpha}{Direct effect (focal variance).}

\item{Vepsilon}{Indirect effect (partner variance).}

\item{Vpsi}{Social responsiveness (among individual variance in slopes).}

\item{Vx}{Partner trait variance.}

\item{Ve}{Residual variance.}

\item{Vxe}{Measurement error/within-individual variation in partner trait.}

\item{r_alpha_epsilon}{Corr(alpha, epsilon).}

\item{r_alpha_psi}{Corr(alpha, psi).}

\item{r_epsilon_psi}{Corr(epsilon, psi).}

\item{r_alpha_x}{Corr(alpha, x).}

\item{r_psi_x}{Corr(psi, x).}

\item{r_epsilon_x}{Corr(epsilon, x).}

\item{fix_total_var}{Logical; if TRUE (default), residual variance is
adjusted so total phenotypic variance is approx. 1.}
}
\value{
A list with:
\itemize{
\item data: list of datasets
\item params: named list of effect sizes
\item design: sample design (n_ind, partners, repeats, iterations)
}
}
\description{
This function generates datasets where individual phenotypes are influenced
by both direct and indirect (social) effects, under a specified sampling design.
}
\examples{
sim <- simulate_data(ind =1200, partners = 4, iterations = 100, B_0 = 1, Valpha=0.2, Vepsilon = 0.1)

}
