% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smfishHmrf.hmrfem.R
\name{smfishHmrf.generate.centroid.use.exist}
\alias{smfishHmrf.generate.centroid.use.exist}
\title{Use existing cluster centroids}
\usage{
smfishHmrf.generate.centroid.use.exist(name = "test", input_dir = ".", par_k)
}
\arguments{
\item{name}{name of this run}

\item{input_dir}{input directory}

\item{par_k}{number of clusters}
}
\value{
A kmeans object which is a list with centers and cluster fields
}
\description{
This function assumes that cluster centroids have already been generated from previously applying kmeans on the dataset. The results should have been saved. It will load cluster centroids from existing clustering result files. The results should be found in \code{input_dir} directory. The function looks for the following two kmeans result files:
\enumerate{
\item \code{{input_dir}}/k_\code{{par_k}}/f\code{{name}}.gene.ALL.centroid.txt
\item \code{{input_dir}}/k_\code{{par_k}}/f\code{{name}}.gene.ALL.kmeans.txt
}

where \code{{}} refers to the value of parameters down below
}
\examples{
kmeans_results = system.file("extdata", package="smfishHmrf")
kk = smfishHmrf.generate.centroid.use.exist(name="test", input_dir=kmeans_results, par_k=9)
}
