% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smfishHmrf.R
\docType{package}
\name{smfishHmrf}
\alias{smfishHmrf}
\title{smfishHmrf: A package for running hidden markov random field on smFISH and other spatial transcriptomic datasets}
\description{
A package for running hidden markov random field \insertCite{Zhu2018}{smfishHmrf} on smFISH and other spatial transcriptomic datasets.
}
\section{Input}{

The inputs of HMRF are the following:
\itemize{
\item Gene expression matrix
\item Cell neighborhood matrix
\item Initial centroids of clusters
\item Number of clusters
\item beta
}

smfishHmrf has been tested to work on seqFISH, MERFISH, starMAP, 10X Visium and other datasets. See Giotto \insertCite{Dries701680}{smfishHmrf} for examples of such datasets and to learn about the technologies.
smfishHmrf is a general algorithm, and should probably work with other data types.
}

\section{Running}{

The first step is to calculate initial centroids on the gene expression matrix given k (the number of clusters). The function \strong{smfishHmrf.generate.centroid.it} is used for this purpose.

The next step is to run the HMRF algorithm given the expression matrix, and cell neighborhood matrix. The function \strong{smfishHmrf.hmrfem.multi.it.min} is used for this purpose.
}

\section{Variations}{

You might notice several variations of the functions:
\itemize{
\item \code{smfishHmrf.hmrfem.multi.it.min}: supports multiple betas; supports file names as inputs. \strong{This is the recommended function.}
\item \code{smfishHmrf.hmrfem.multi.it}: supports multiple betas; supports R data structures as inputs.
\item \code{smfishHmrf.hmrfem.multi}: supports a single beta; supports R data structures as inputs.
\item Note: beta is the smoothness parameter of HMRF
}

Also:
\itemize{
\item \code{smfishHmrf.generate.centroid.it}: supports file names as inputs. \strong{This is the recommended function}
\item \code{smfishHmrf.generate.centroid}: supports R matrices as inputs. Assumes input files have been read into R matrices.
\item \code{smfishHmrf.generate.centroid.use.exist}: loads existing centroids. Assumes that centroids have been generated previously and saved to disk.
}
}

\references{
\insertRef{Zhu2018}{smfishHmrf}

\insertRef{Dries701680}{smfishHmrf}
}
