% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_cdf.R
\name{demp}
\alias{demp}
\title{Empirical probability density function (EPDF)}
\usage{
demp(x, sample)
}
\arguments{
\item{x}{numeric vector of values to evaluate}

\item{sample}{numeric vector of sample values to base the EPDF on}
}
\value{
numeric vector of density values based on the EPDF
}
\description{
Empirical probability density function based on a sample of observations,
as described by Chakraborti (2006).
}
\examples{
x <- 1:5
demp(1, x)
}
\references{
Chakraborti, S., Hong, B., & Van De Wiel, M. A. (2006).
A note on sample size determination for a nonparametric test of location.
Technometrics, 48(1), 88–94. https://doi.org/10.1198/004017005000000193
}
