% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{aws_user_create}
\alias{aws_user_create}
\title{Create a user}
\usage{
aws_user_create(username, path = NULL, permission_boundary = NULL, tags = NULL)
}
\arguments{
\item{username}{(character) A user name. required}

\item{path}{(character) The path for the user name. optional.
If it is not included, it defaults to a slash (/).}

\item{permission_boundary}{(character) The ARN of the managed policy
that is used to set the permissions boundary for the user. optional}

\item{tags}{(list) A list of tags that you want to attach to the new user.
optional}
}
\value{
A tibble with information about the user created
}
\description{
Create a user
}
\details{
See \url{https://www.paws-r-sdk.com/docs/iam_create_user/}
docs for details on the parameters
}
\examples{
\dontshow{if (interactive() && aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
user1 <- random_user()
if (aws_user_exists(user1)) {
  aws_user_delete(user1)
}
aws_user_create(user1)

# cleanup
aws_user_delete(user1)
\dontshow{\}) # examplesIf}
}
\seealso{
Other users: 
\code{\link{aws_user}()},
\code{\link{aws_user_access_key}()},
\code{\link{aws_user_access_key_delete}()},
\code{\link{aws_user_add_to_group}()},
\code{\link{aws_user_current}()},
\code{\link{aws_user_delete}()},
\code{\link{aws_user_exists}()},
\code{\link{aws_users}()},
\code{\link{six_user_create}()},
\code{\link{six_user_delete}()}
}
\concept{users}
