% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{aws_group_exists}
\alias{aws_group_exists}
\title{Check if a group exists}
\usage{
aws_group_exists(name)
}
\arguments{
\item{name}{(character) the group name}
}
\value{
a single boolean
}
\description{
Check if a group exists
}
\details{
uses \code{aws_group} internally. see docs
\url{https://www.paws-r-sdk.com/docs/iam_get_group/}
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
aws_group_create("apples")
aws_group_exists("apples")
aws_group_exists("doesnotexist")
# cleanup
aws_group_delete("apples")
\dontshow{\}) # examplesIf}
}
\seealso{
Other groups: 
\code{\link{aws_group}()},
\code{\link{aws_group_create}()},
\code{\link{aws_group_delete}()},
\code{\link{aws_groups}()},
\code{\link{six_group_delete}()}
}
\concept{groups}
