% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sitepickR_diagnostics.R
\name{subUnitBalance}
\alias{subUnitBalance}
\title{Sub-unit balance}
\usage{
subUnitBalance(
  smOut,
  title = "Subunits from Original and Replacement Unit Groups vs. Population (SMD)"
)
}
\arguments{
\item{smOut}{list; selectMatch() output}

\item{title}{character; user-specified figure title}
}
\value{
ggplot object
}
\description{
Sub-unit balance between initially selected units and all units in population, for each covariate of interest
}
\examples{
################################################################################
############## Balance Diagnostics [sitepickR Package] #########################
######### Robert Olsen, Elizabeth A. Stuart & Elena Badillo-Goicoechea (2022) ##
################################################################################

# Basic usage of subUnitBalance()
rawCCD <- sitepickR::rawCCD

uSampVarsCCD <- c("w.pct.frlunch", "w.pct.black", "w.pct.hisp", "w.pct.female") 
suSampVarsCCD <- c("sch.pct.frlunch", "sch.pct.black", "sch.pct.hisp", "sch.pct.female")

dfCCD <- prepDF(rawCCD,
                unitID="LEAID", subunitID="NCESSCH")
dfCCD <- dplyr::filter(dfCCD, unitID \%in\% unique(dfCCD$unitID)[1:80])

smOut <- selectMatch(df = dfCCD, # user dataset
                     unitID = "LEAID", # column name of unit ID in user dataset
                     subunitID = "NCESSCH", # column name of sub-unit ID in user dataset
                     unitVars = uSampVarsCCD, # name of unit level covariate columns
                     subunitSampVars = suSampVarsCCD, # name of sub-unit level covariate columns
                     nUnitSamp = 30,
                     nRepUnits = 5,
                     nsubUnits = 2
)
subUnitBalance(smOut =smOut,
               title="Standardized Mean Difference:
               Sub-units from Original + Replacement Unit Groups vs. Population")
}
