% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectMatch.R
\name{selectMatch}
\alias{selectMatch}
\title{Two-level sample selection}
\usage{
selectMatch(
  df,
  unitID,
  subunitID,
  subunitSampVars,
  unitVars,
  nUnitSamp,
  nRepUnits,
  nsubUnits,
  exactMatchVars = NULL,
  calipMatchVars = NULL,
  calipValue = 0.2,
  seedN = NA,
  matchDistance = "mahalanobis",
  sizeFlag = TRUE,
  repFlag = TRUE,
  writeOut = FALSE,
  replacementUnitsFilename = "replacementUnits.csv",
  subUnitTableFilename = "subUnitTable.csv"
)
}
\arguments{
\item{df}{dataframe; sub-unit level dataframe with both sub-unit and unit level variables}

\item{unitID}{character; name of unit ID column}

\item{subunitID}{character; name of sub-unit ID column}

\item{subunitSampVars}{vector;  column names of unit level variables  to sample units on}

\item{unitVars}{vector; column names of unit level variables  to match units on}

\item{nUnitSamp}{numeric; number of units to be initially randomly selected}

\item{nRepUnits}{numeric; number of replacement units to find for each selected unit}

\item{nsubUnits}{numeric; number of sub-units to be randomly selected for each unit}

\item{exactMatchVars}{vector; column names of categorical variables on which units must be matched exactly. Must be present in 'unitVars'; default = NULL}

\item{calipMatchVars}{vector; column names of continuous variables on which units must be matched within a specified caliper. Must be present in 'unitVars'; default = NULL}

\item{calipValue}{numeric; number of standard deviations to be used as caliper for matching units on calipMatchVars}

\item{seedN}{numeric; seed number to be used for sampling. If NA, calls set.seed(); default = NA}

\item{matchDistance}{character; MatchIt distance parameter to obtain optimal matches (nearest neigboors); default = "mahalanois"}

\item{sizeFlag}{logical; if TRUE, sampling is made proportional to unit size; default = TRUE}

\item{repFlag}{logical; if TRUE, pick unit matches with/without repetition; default = TRUE}

\item{writeOut}{logical; if TRUE, writes a .csv file for each output table; default = FALSE}

\item{replacementUnitsFilename}{character; csv filename for saving {unit:replacement} directory when writeOut == TRUE; default = "replacementUnits.csv"}

\item{subUnitTableFilename}{character; csv filename for saving {unit:replacement} directory when writeOut == TRUE; default = "subUnitTable.csv"}
}
\value{
list with: 1) table of the form: {selected unit i: (unit i replacements)}, 2) table of the form: {potential unit i:(unit i sub-units)}, 3) balance diagnostics.
}
\description{
Carries out a two-level sample selection where the possibility of an initially selected
site not wanting to participate is anticipated, and the site is optimally replaced. 
The procedure aims to reduce the bias (and/or loss of generalizability) with respect to the target population.
}
\examples{
################################################################################
############## Prepare dataframe [sitepickR Package] ###########################
######### Robert Olsen, Elizabeth A. Stuart & Elena Badillo-Goicoechea (2022) ##

# Basic usage of selectMatch()

rawCCD <- sitepickR::rawCCD

uSampVarsCCD <- c("w.pct.frlunch", "w.pct.black", "w.pct.hisp", "w.pct.female") 
suSampVarsCCD <- c("sch.pct.frlunch", "sch.pct.black", "sch.pct.hisp", "sch.pct.female")

dfCCD <- prepDF(rawCCD,
                unitID="LEAID", subunitID="NCESSCH")
dfCCD <- dplyr::filter(dfCCD, unitID \%in\% unique(dfCCD$unitID)[1:80])

smOut <- selectMatch(df = dfCCD, # user dataset
                     unitID = "LEAID", # column name of unit ID in user dataset
                     subunitID = "NCESSCH", # column name of sub-unit ID in user dataset
                     unitVars = uSampVarsCCD, # name of unit level covariate columns
                     subunitSampVars = suSampVarsCCD, # name of sub-unit level covariate columns
                     nUnitSamp = 30,
                     nRepUnits = 5,
                     nsubUnits = 2
)
}
