% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{sisti}
\alias{sisti}
\title{qPCR data sets by Sisti et al. (2010)}
\format{
A \link[tibble:tibble-package]{tibble} providing amplification curve data
in long format. Each row is for an amplification curve point.

\describe{
\item{\code{plate}}{Plate identifier. There is one identifier for each of the four
data sets.}
\item{\code{well}}{Well identifier, i.e. the position within a PCR plate. This
information was not available from the original publication, thus all values
are \code{NA}.}
\item{\code{target}}{Target identifier. In all data sets the target is an amplicon
consisting of a 104 bp fragment of the mitochondrial gene NADH dehydrogenase
1 (MT-ND1), thus the values are all \code{"MT-ND1"}.}
\item{\code{dye}}{Type of fluorescence dye, in this data set it is always SYBR
Green I master mix (Roche) (\code{"SYBR"}).}
\item{\code{sample}}{Name of the biological sample. All samples are based on a
pGEM-T Promega plasmid, so all values are \code{"pGEM-T"}.}
\item{\code{sample_type}}{Sample type. All reactions are standard curves, i.e.
\code{"std"}.}
\item{\code{inhibitor}}{Name of the molecule used as PCR inhibitor. In the case of
the dilution series the value is \code{"none"}.}
\item{\code{inhibitor_conc}}{Inhibitor concentration in mg/mL.}
\item{\code{replicate}}{Replicate identifier.}
\item{\code{copies}}{Standard copy number of the amplicon.}
\item{\code{dilution}}{Dilution factor. Higher number means greater dilution, e.g.
\code{10} means a 1:10 (ten-fold) dilution.}
\item{\code{cycle}}{PCR cycle.}
\item{\code{fluor}}{Raw fluorescence values.}
}
}
\source{
\doi{10.1186/1471-2105-11-186}
}
\description{
One single tabular tidy data set in long format, encompassing four data sets
of amplification curves: (i) six-point, ten-fold dilution series, (ii) tannic
acid inhibition, (iii) IgG inhibition and (iv) quercitin inhibition. The
target amplicon consisted of a 104 bp fragment of the mitochondrial gene NADH
dehydrogenase 1 (MT-ND1). Please read the Methods section of Sisti et al.
(2010) for more experimental details.
\subsection{Dilution series}{

A six-point, ten-fold dilution series spanning an amplicon copy number range
\eqn{3.14 \times 10^7} thru \eqn{3.14 \times 10^2}. Each concentration is
replicated twelve times. Each reaction has been amplified through 50 cycles.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::filter(sisti, plate == "calibration")
#> # A tibble: 3,600 x 13
#>    plate       well  target dye   sample sample_type inhibitor inhibitor_conc
#>    <fct>       <fct> <fct>  <fct> <fct>  <fct>       <fct>              <dbl>
#>  1 calibration <NA>  MT-ND1 SYBR  pGEM-T std         none                   0
#>  2 calibration <NA>  MT-ND1 SYBR  pGEM-T std         none                   0
#>  3 calibration <NA>  MT-ND1 SYBR  pGEM-T std         none                   0
#>  4 calibration <NA>  MT-ND1 SYBR  pGEM-T std         none                   0
#>  5 calibration <NA>  MT-ND1 SYBR  pGEM-T std         none                   0
#>  6 calibration <NA>  MT-ND1 SYBR  pGEM-T std         none                   0
#>  7 calibration <NA>  MT-ND1 SYBR  pGEM-T std         none                   0
#>  8 calibration <NA>  MT-ND1 SYBR  pGEM-T std         none                   0
#>  9 calibration <NA>  MT-ND1 SYBR  pGEM-T std         none                   0
#> 10 calibration <NA>  MT-ND1 SYBR  pGEM-T std         none                   0
#> # i 3,590 more rows
#> # i 5 more variables: replicate <fct>, copies <int>, dilution <int>,
#> #   cycle <int>, fluor <dbl>
}\if{html}{\out{</div>}}
}

\subsection{Tannic acid inhibition}{

A series of reactions subjected to inhibition by tannic acid with
concentrations: 0.000391, 0.000781, 0.00156, 0.00312, 0.00625, 0.0125, 0.025,
0.05 and 0.1 mg/mL. Each tannic acid concentration sample is replicated six
times. Each reaction has been amplified through 40 cycles.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::filter(sisti, plate == "tannic acid")
#> # A tibble: 2,160 x 13
#>    plate       well  target dye   sample sample_type inhibitor   inhibitor_conc
#>    <fct>       <fct> <fct>  <fct> <fct>  <fct>       <fct>                <dbl>
#>  1 tannic acid <NA>  MT-ND1 SYBR  pGEM-T std         tannic acid            0.1
#>  2 tannic acid <NA>  MT-ND1 SYBR  pGEM-T std         tannic acid            0.1
#>  3 tannic acid <NA>  MT-ND1 SYBR  pGEM-T std         tannic acid            0.1
#>  4 tannic acid <NA>  MT-ND1 SYBR  pGEM-T std         tannic acid            0.1
#>  5 tannic acid <NA>  MT-ND1 SYBR  pGEM-T std         tannic acid            0.1
#>  6 tannic acid <NA>  MT-ND1 SYBR  pGEM-T std         tannic acid            0.1
#>  7 tannic acid <NA>  MT-ND1 SYBR  pGEM-T std         tannic acid            0.1
#>  8 tannic acid <NA>  MT-ND1 SYBR  pGEM-T std         tannic acid            0.1
#>  9 tannic acid <NA>  MT-ND1 SYBR  pGEM-T std         tannic acid            0.1
#> 10 tannic acid <NA>  MT-ND1 SYBR  pGEM-T std         tannic acid            0.1
#> # i 2,150 more rows
#> # i 5 more variables: replicate <fct>, copies <int>, dilution <int>,
#> #   cycle <int>, fluor <dbl>
}\if{html}{\out{</div>}}
}

\subsection{Immunoglobulin G (IgG) inhibition}{

A series of reactions subjected to inhibition by IgG with concentrations:
0.00781, 0.0156, 0.0312, 0.0625, 0.125, 0.25, 0.5, 1 and 2 mg/mL. Each IgG
concentration sample is replicated six times. Each reaction has been
amplified through 40 cycles.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::filter(sisti, plate == "IgG")
#> # A tibble: 2,160 x 13
#>    plate well  target dye   sample sample_type inhibitor inhibitor_conc
#>    <fct> <fct> <fct>  <fct> <fct>  <fct>       <fct>              <dbl>
#>  1 IgG   <NA>  MT-ND1 SYBR  pGEM-T std         IgG                    2
#>  2 IgG   <NA>  MT-ND1 SYBR  pGEM-T std         IgG                    2
#>  3 IgG   <NA>  MT-ND1 SYBR  pGEM-T std         IgG                    2
#>  4 IgG   <NA>  MT-ND1 SYBR  pGEM-T std         IgG                    2
#>  5 IgG   <NA>  MT-ND1 SYBR  pGEM-T std         IgG                    2
#>  6 IgG   <NA>  MT-ND1 SYBR  pGEM-T std         IgG                    2
#>  7 IgG   <NA>  MT-ND1 SYBR  pGEM-T std         IgG                    2
#>  8 IgG   <NA>  MT-ND1 SYBR  pGEM-T std         IgG                    2
#>  9 IgG   <NA>  MT-ND1 SYBR  pGEM-T std         IgG                    2
#> 10 IgG   <NA>  MT-ND1 SYBR  pGEM-T std         IgG                    2
#> # i 2,150 more rows
#> # i 5 more variables: replicate <fct>, copies <int>, dilution <int>,
#> #   cycle <int>, fluor <dbl>
}\if{html}{\out{</div>}}
}

\subsection{Quercitin inhibition}{

A series of reactions subjected to inhibition by quercitin with
concentrations: 0.000312, 0.000625, 0.00125, 0.0025, 0.005, 0.01, 0.02, and
0.04 mg/mL. Each quercitin concentration sample is replicated six times. Each
reaction has been amplified through 40 cycles.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::filter(sisti, plate == "quercitin")
#> # A tibble: 1,920 x 13
#>    plate     well  target dye   sample sample_type inhibitor inhibitor_conc
#>    <fct>     <fct> <fct>  <fct> <fct>  <fct>       <fct>              <dbl>
#>  1 quercitin <NA>  MT-ND1 SYBR  pGEM-T std         quercitin           0.04
#>  2 quercitin <NA>  MT-ND1 SYBR  pGEM-T std         quercitin           0.04
#>  3 quercitin <NA>  MT-ND1 SYBR  pGEM-T std         quercitin           0.04
#>  4 quercitin <NA>  MT-ND1 SYBR  pGEM-T std         quercitin           0.04
#>  5 quercitin <NA>  MT-ND1 SYBR  pGEM-T std         quercitin           0.04
#>  6 quercitin <NA>  MT-ND1 SYBR  pGEM-T std         quercitin           0.04
#>  7 quercitin <NA>  MT-ND1 SYBR  pGEM-T std         quercitin           0.04
#>  8 quercitin <NA>  MT-ND1 SYBR  pGEM-T std         quercitin           0.04
#>  9 quercitin <NA>  MT-ND1 SYBR  pGEM-T std         quercitin           0.04
#> 10 quercitin <NA>  MT-ND1 SYBR  pGEM-T std         quercitin           0.04
#> # i 1,910 more rows
#> # i 5 more variables: replicate <fct>, copies <int>, dilution <int>,
#> #   cycle <int>, fluor <dbl>
}\if{html}{\out{</div>}}
}
}
\examples{
sisti

}
\keyword{datasets}
