% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinib.R
\name{psinib}
\alias{psinib}
\alias{dsinib}
\alias{rsinib}
\alias{qsinib}
\title{Distribution of Sum of Independent Non-Identical Binomial Random Variables}
\source{
See Eisinga et al (2012) Saddlepoint approximations for the sum of independent non-identically distributed binomial random variables. Available from \url{http://onlinelibrary.wiley.com/doi/10.1111/stan.12002/full}
}
\usage{
psinib(q, size, prob, lower.tail = TRUE, log.p = FALSE)

dsinib(x, size, prob, log = FALSE)

rsinib(n, size, prob)

qsinib(p, size, prob)
}
\arguments{
\item{size}{integer vector of number of trials (see detail).}

\item{prob}{numeric vector of success probabilities (see detail).}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P[S<=s]}, otherwise, \eqn{P[S>s]}.}

\item{x, q}{integer vector of quantiles.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{n}{numeric scalar to indicate number of observations.}

\item{p}{numeric vector of probabilities.}
}
\value{
qsinib gives the cumulative distribution of sum of independent non-identical random variables.
}
\description{
Density, distribution function, quantile function, and random number generation for the sum of independent non-identical binomial random variables
}
\details{
Suppose S is a random variable formed by summing R independent non-identical random variables \eqn{X_r}{Xr}, \eqn{r = 1,...,R}. \deqn{S = \sum_{r=1}^R X_r}{S = X1+X2+...XR}
\code{size} and \code{prob} should both be vectors of length R. The first elements of \code{size} and \code{prob} specifies \eqn{X_1}{X1}, the second elements specifies \eqn{X_2}{X2}, so on and so forth. The probability \eqn{F(S)} is calculated using Daniels' second-order continuity-corrected saddlepoint approximation. The density \eqn{p(S)} is calculated using second-order saddlepoint mass approximation with Butler's normalization.
}
\examples{
# Calculating the density and probability:
size <- as.integer(c(12, 14, 4, 2, 20, 17, 11, 1, 8, 11))
prob <- c(0.074, 0.039, 0.095, 0.039, 0.053, 0.043, 0.067, 0.018, 0.099, 0.045)
q <- x <- as.integer(seq(1, 19, 2))
dsinib(x, size, prob)
psinib(q, size, prob)

# Generating random samples:
rsinib(100, size, prob)

# Calculating quantiles:
p <- psinib(q, size, prob) 
qsinib(p, size, prob)

}
