% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traverse.R
\name{traverse}
\alias{traverse}
\title{Finds the path as you traverse the graph}
\usage{
traverse(db_file, src, tgt = NA, neighbors_fn = "find_neighbors")
}
\arguments{
\item{db_file}{The name of the SQLite database}

\item{src}{The id of the source node}

\item{tgt}{The id of the target node (optional)}

\item{neighbors_fn}{The neighbor function to employ.  Valid options are find_neighbors, find_inbound_neighbors or find_outbound_neighbors (optional)}
}
\value{
A JSON object containing the id of the nodes in the path
}
\description{
Finds the path as you traverse the graph
}
\examples{
\dontrun{
library(simplegraphdb)
apple <- "apple_test.sqlite"
initialize(apple)
atomic(apple, add_node(list(
  "name" = "Apple Computer Company",
  "type" = c("company", "start-up"),
  "founded" = "April 1, 1976"), 1))
atomic(apple, add_node(list(
  "name" = "Steve Wozniak",
  "type" = c("person", "engineer", "founder")), 2))
atomic(apple, add_node(list(
  "name" = "Steve Jobs",
  "type" = c("person", "designer", "founder")), 3))
atomic(apple, add_node(list(
  "name" = "Ronald Wayne",
  "type" = c("person", "administrator", "founder")), 4))
atomic(apple, add_node(list(
  "name" = "Mike Markkula",
  "type" = c("person", "investor")), 5))
atomic(apple, connect_nodes(2, 1, list("action" = "founded")))
atomic(apple, connect_nodes(3, 1, list("action" = "founded")))
atomic(apple, connect_nodes(4, 1, list("action" = "founded")))
atomic(apple, connect_nodes(5, 1, list(
  "action" = "invested",
  "equity" = 80000,
  "debt" = 170000)))
atomic(apple, connect_nodes(1, 4, list(
  "action" = "divested",
  "amount" = 800,
  "date" = "April 12, 1976")))
atomic(apple, connect_nodes(2, 3))
atomic(apple, upsert_node(2, list("nickname" = "Woz"), apple))

# Traverse the data
traverse(apple, 4, 5)

# Get the inbound neighbors
traverse(apple, 5, "find_inbound_neighbors")

# Get the outbound neighbors
traverse(apple, 5, "find_outbound_neighbors")
}
}
