% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{internal.prop2.test}
\alias{internal.prop2.test}
\title{Internal function for Two-sample Proportions Test}
\usage{
internal.prop2.test(
  x,
  y,
  p = NULL,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  correct = TRUE,
  na.rm = TRUE
)
}
\arguments{
\item{x}{First binary variable.}

\item{y}{Second binary variable.}

\item{p}{Null hypothesis value for proportion. Default is NULL.}

\item{alternative}{A character string specifying the alternative hypothesis. One of \code{"two.sided"}, \code{"less"}, or \code{"greater"}. Default is \code{"two.sided"}.}

\item{conf.level}{A numeric value between 0 and 1 indicating the confidence level for the interval estimate of the proportion. Default is 0.95.}

\item{correct}{A logical indicating if Yates' continuity correction should be applied for the test. Default is TRUE.}

\item{na.rm}{A logical indicating if NA values should be removed. Default is TRUE.}
}
\value{
A data frame with test results.
}
\description{
Computes the test for proportions for two given binary variables.
}
