% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piecewiseDistribution.R
\name{getPCWDistr}
\alias{getPCWDistr}
\title{Piecewise Exponentially Distributed Event Times}
\usage{
getPCWDistr(U, haz, pw, t_0)
}
\arguments{
\item{U}{(\code{numeric})\cr uniformly distributed random variables.}

\item{haz}{(\code{numeric})\cr piecewise constant hazard.}

\item{pw}{(\code{numeric})\cr time intervals for the piecewise constant hazard.}

\item{t_0}{(\code{numeric})\cr the starting times.}
}
\value{
This returns a vector with event times.
}
\description{
This returns event times with a distribution resulting from piece-wise constant hazards
using the inversion method.
}
\examples{
getPCWDistr(U = runif(3), haz = c(1.1, 0.5, 0.4), pw = c(0, 7, 10), t_0 = c(0, 1, 4.2))
}
