% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateParams.R
\name{estimateParams}
\alias{estimateParams}
\title{Estimate Parameters of the Multistate Model Using Clinical Trial Data}
\usage{
estimateParams(data, transition)
}
\arguments{
\item{data}{(\code{data.frame})\cr in the format produced by \code{\link[=getOneClinicalTrial]{getOneClinicalTrial()}}.}

\item{transition}{(\code{TransitionParameters} object)\cr specifying the assumed distribution of transition hazards.
Initial parameters for optimization can be specified here.
See \code{\link[=exponential_transition]{exponential_transition()}} or \code{\link[=weibull_transition]{weibull_transition()}} for details.}
}
\value{
Returns a \code{TransitionParameters} object with the estimated parameters.
}
\description{
Estimate Parameters of the Multistate Model Using Clinical Trial Data
}
\details{
This function estimates parameters for transition models using clinical trial data.
The \code{transition} object can be initialized with starting values for parameter estimation.
It uses \code{\link[stats:optim]{stats::optim()}} to optimize the parameters.
}
\examples{
transition <- exponential_transition(h01 = 2, h02 = 1.4, h12 = 1.6)
simData <- getOneClinicalTrial(
  nPat = c(30), transitionByArm = list(transition),
  dropout = list(rate = 0.3, time = 12),
  accrual = list(param = "time", value = 1)
)
# Initialize transition with desired starting values for optimization:
transition <- exponential_transition(h01 = 1.2, h02 = 1.5, h12 = 1.6)
estimate <- estimateParams(simData, transition)
}
