% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corPFSOS.R
\name{corPFSOS}
\alias{corPFSOS}
\title{Correlation of PFS and OS event times for data from the IDM}
\usage{
corPFSOS(
  data,
  transition,
  bootstrap = TRUE,
  bootstrap_n = 100,
  conf_level = 0.95
)
}
\arguments{
\item{data}{(\code{data.frame})\cr in the format produced by \code{\link[=getOneClinicalTrial]{getOneClinicalTrial()}}.}

\item{transition}{(\code{TransitionParameters} object)\cr specifying the assumed distribution of transition hazards.
Initial parameters for optimization can be specified here.
See \code{\link[=exponential_transition]{exponential_transition()}} or \code{\link[=weibull_transition]{weibull_transition()}} for details.}

\item{bootstrap}{(\code{flag})\cr if \code{TRUE} computes confidence interval via bootstrap.}

\item{bootstrap_n}{(\code{count})\cr number of bootstrap samples.}

\item{conf_level}{(\code{proportion})\cr confidence level for the confidence interval.}
}
\value{
The correlation of PFS and OS.
}
\description{
Correlation of PFS and OS event times for data from the IDM
}
\examples{
transition <- exponential_transition(h01 = 1.2, h02 = 1.5, h12 = 1.6)
data <- getClinicalTrials(
  nRep = 1, nPat = c(100), seed = 1234, datType = "1rowTransition",
  transitionByArm = list(transition), dropout = list(rate = 0.5, time = 12),
  accrual = list(param = "intensity", value = 7)
)[[1]]
corPFSOS(data, transition = exponential_transition(), bootstrap = FALSE)
\dontrun{
corPFSOS(data, transition = exponential_transition(), bootstrap = TRUE)
}
}
