% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_parameters.R
\name{create_parameters}
\alias{create_parameters}
\title{Create parameters for data-generating models}
\usage{
create_parameters(
  nbinary = 0,
  ncontinuous = 0,
  ncount = 0,
  unmeasured_conf = "u1",
  unmeasured_type = "binary",
  file = NULL
)
}
\arguments{
\item{nbinary, ncontinuous, ncount}{the number of binary, continuous, and count confounders to include, respectively. Default is 0.}

\item{unmeasured_conf}{the name of the unmeasured confounder. Default is \code{"u1"}.}

\item{unmeasured_type}{the type of variable for the unmeasured confounder. Allowable options include \code{"binary"}, \code{"continuous"}, and \code{"count"}. Default is \code{"binary"}; abbreviations allowed.}

\item{file}{optional; a string containing a path to a .csv or .xslx file where the output will be written to. If \code{NULL} (the default), no file will be written.}
}
\value{
A data.frame containing a skeleton of the parameter values, which must be filled in manually by the user. See \emph{The \code{parameters} input object} section in the \code{\link[=simBA]{simBA()}} documentation for which columns will be present in the output. An additional column, Description, will also be produced, but it is not necessary to fill it in.
}
\description{
\code{create_parameters()} facilitates creation of the \code{parameters} input to \code{\link[=simBA]{simBA()}}. This input contains information required to generate simulated dataset that will be analyzed within the simulation.
}
\examples{
parameters <- create_parameters(nbinary = 6,
                                ncontinuous = 2,
                                ncount = 1,
                                unmeasured_conf = "u1",
                                unmeasured_type = "continuous")

parameters
}
