% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clip_generate_bbox.R
\name{generate_bbox}
\alias{generate_bbox}
\title{Generate a Bounding Box as an sf Object}
\usage{
generate_bbox(layer)
}
\arguments{
\item{layer}{An `sf` object or a `terra::SpatRaster` object.}
}
\value{
An `sf` object representing the bounding box of the input layer.
}
\description{
Takes an `sf` object or a `terra::SpatRaster` as input and returns a new `sf` object
representing the bounding box (minimum bounding rectangle) of the input layer.
}
\examples{
# Example with a vector layer
source_gpkg <- system.file("extdata/sigugr.gpkg", package = "sigugr")
lanjaron <- sf::st_read(source_gpkg, layer = "lanjaron", quiet = TRUE)
bbox_vector <- generate_bbox(lanjaron)

# Example with a raster layer
raster_file <- system.file("extdata/sat.tif", package = "sigugr")
raster <- terra::rast(raster_file)
bbox_raster <- generate_bbox(raster)

}
\seealso{
Other clip functions: 
\code{\link{clip_layer}()},
\code{\link{clip_multipoligon}()},
\code{\link{clip_raster}()}
}
\concept{clip functions}
