% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_stopwords.R
\name{match_stopwords}
\alias{match_stopwords}
\title{Remove Stopwords from User Reviews}
\usage{
match_stopwords(df)
}
\arguments{
\item{df}{Dataframe containing user reviews, with required columns \code{comment} (text) and \code{rating} (numerical score).}
}
\value{
A modified dataframe with an additional \code{cleaned_text} column containing stopword-free text.
}
\description{
This function processes a dataframe containing user reviews and removes predefined stopwords.
It first searches the package's internal stopwords dataset (\code{stopwords_tr}), and if
no match is found, it falls back to the broader \code{stopwords_iso} list.
}
\details{
The function converts text to a standardized format by removing accents and special characters,
transforming it into basic Latin characters, and making all letters lowercase. It then
tokenizes the text, filters out stopwords, and returns the cleaned version.
}
\examples{
reviews_sample <- tibble::tibble(
  comment = c("Bu ürün xs ancak fiyatı yüksek gibi",
              "Fiyat çok pahalı ama kaliteli iyi"),
  rating = c(4.5, 3.0)
)
match_stopwords(reviews_sample)
}
