% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/payload.R
\name{payload_last}
\alias{payload_last}
\title{Get a reactive that polls for new payload data}
\usage{
payload_last(path = "/ingress", session, intervalMillis = 300)
}
\arguments{
\item{path}{The URL path used in payload_ui() (default "/ingress")}

\item{session}{The Shiny session object}

\item{intervalMillis}{Polling interval in milliseconds (default 300)}
}
\value{
A reactive expression (class "reactive") that returns a list with two
elements when new data is available: \code{payload} (the parsed request body)
and \code{meta} (metadata including timestamp, remote address, headers, etc.),
or \code{NULL} if no data has been received yet.
}
\description{
Get a reactive that polls for new payload data
}
\examples{
if (interactive()) {
server <- function(input, output, session) {
  latest_data <- payload_last("/data", session)

  observeEvent(latest_data(), {
    data <- latest_data()
    if (!is.null(data)) {
      print(data$payload)
      print(data$meta$timestamp)
    }
  })
}
}
}
