% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_ui.R
\name{view_ui}
\alias{view_ui}
\title{Show UI output in viewer pane}
\usage{
view_ui(x, close_after = 5)
}
\arguments{
\item{x}{ui content (actionButton, selectInput, valueBox), if x is not provided, \code{view_ui()} will look for selected text in the source pane or the last output from running the UI code. In the latter case, it expects an object with class "shiny.tag" or "shiny.tag.list"}

\item{close_after}{number of seconds to display UI in Viewer panel. If NULL, app must be stopped manually before more code can be run.}
}
\description{
Show UI output in viewer pane
}
\examples{
if (interactive()) {
# run this line
shiny::selectInput(
  "state",
  "Choose a state:",
  list(
    `East Coast` = list("NY", "NJ", "CT"),
    `West Coast` = list("WA", "OR", "CA"),
    `Midwest` = list("MN", "WI", "IA")
  )
)
# the output will automatically be used here
view_ui(close_after = 6)
}

}
