% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-auth.R
\name{module-authentication}
\alias{module-authentication}
\alias{auth_ui}
\alias{auth_server}
\title{Authentication module}
\usage{
auth_ui(
  id,
  status = "primary",
  tags_top = NULL,
  tags_bottom = NULL,
  background = NULL,
  choose_language = NULL,
  lan = NULL,
  ...
)

auth_server(
  input,
  output,
  session,
  check_credentials,
  use_token = FALSE,
  lan = NULL
)
}
\arguments{
\item{id}{Module's id.}

\item{status}{Bootstrap status to use for the panel and the button.
Valid status are: \code{"default"}, \code{"primary"}, \code{"success"},
\code{"warning"}, \code{"danger"}.}

\item{tags_top}{A \code{tags (div, img, ...)} to be displayed on top of the authentication module.}

\item{tags_bottom}{A \code{tags (div, img, ...)} to be displayed on bottom of the authentication module.}

\item{background}{A optionnal \code{css} for authentication background. See example.}

\item{choose_language}{\code{logical/character}. Add language selection on top ? TRUE for all supported languages
or a vector of possibilities like \code{c("en", "es")}. If enabled, \code{input$shinydbauth_language} is created}

\item{lan}{A language object. See  \code{\link{use_language}}}

\item{...}{: Used for old version compatibility.}

\item{input, output, session}{Standard Shiny server arguments.}

\item{check_credentials}{Function with two arguments (\code{user},
the username provided by the user and \code{password}, his/her password).
Must return a \code{list} with at least 2 (or 4 in case of sqlite) slots :
\itemize{
 \item \strong{result} : logical, result of authentication.
 \item \strong{user_info} : \code{list}. What you want about user ! (sqlite : the line in \code{db} corresponding to the user).
 \item \strong{expired} : logical, is user has expired ? Always \code{FALSE} if \code{db} doesn't have a \code{expire} column. Optional.
 \item \strong{authorized} : logical, is user can access to his app ? Always \code{TRUE} if \code{db} doesn't have a \code{applications} column. Optional.
}}

\item{use_token}{Add a token in the URL to check authentication. Should not be used directly.}
}
\value{
A \code{reactiveValues} with 3 slots :
 \itemize{
  \item \strong{result} : logical, result of authentication.
  \item \strong{user} : character, name of connected user.
  \item \strong{user_info} : information about the user.
 }
}
\description{
Authentication module
}
