% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/inputs.R
\name{select}
\alias{select}
\alias{select_input}
\alias{select_section}
\alias{select_item}
\alias{update_select_input}
\title{select}
\usage{
select_input(inputId, ..., value = default_value)

select_section(...)

select_item(...)

update_select_input(session = shiny::getDefaultReactiveDomain(), inputId, ...)
}
\arguments{
\item{inputId}{ID of the component.}

\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI select component.
}
\description{
A select displays a collapsible list of options and allows a user to select one or more of them.
}
\details{
\enumerate{
\item Select Props
\itemize{
\item \bold{children*}. Type: \code{ReactNode[]}. Default: \code{NA}.
\item \bold{items}. Type: \code{Iterable<T>}. Default: \code{NA}.
\item \bold{selectionMode}. Type: \code{single OR multiple}. Default: \code{NA}.
\item \bold{selectedKeys}. Type: \code{all OR Iterable<React.Key>}. Default: \code{NA}.
\item \bold{disabledKeys}. Type: \code{Iterable<React.Key>}. Default: \code{NA}.
\item \bold{defaultSelectedKeys}. Type: \code{all OR Iterable<React.Key>}. Default: \code{NA}.
\item \bold{variant}. Type: \code{flat OR bordered OR faded OR underlined}. Default: \code{"flat"}.
\item \bold{color}. Type: \code{default OR primary OR secondary OR success OR warning OR danger}. Default: \code{"default"}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg OR full}. Default: \code{NA}.
\item \bold{placeholder}. Type: \code{string}. Default: \code{"Select an option"}.
\item \bold{labelPlacement}. Type: \code{inside OR outside OR outside-left}. Default: \code{"inside"}.
\item \bold{label}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{description}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{errorMessage}. Type: \code{ReactNode OR ((v: ValidationResult) => ReactNode)}. Default: \code{NA}.
\item \bold{startContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{endContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{selectorIcon}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{scrollRef}. Type: \code{React.RefObject<HTMLElement>}. Default: \code{NA}.
\item \bold{spinnerRef}. Type: \code{React.RefObject<HTMLElement>}. Default: \code{NA}.
\item \bold{maxListboxHeight}. Type: \code{number}. Default: \code{"256"}.
\item \bold{itemHeight}. Type: \code{number}. Default: \code{"32"}.
\item \bold{isVirtualized}. Type: \code{boolean}. Default: \code{"undefined"}.
\item \bold{fullWidth}. Type: \code{boolean}. Default: \code{true}.
\item \bold{isOpen}. Type: \code{boolean}. Default: \code{NA}.
\item \bold{defaultOpen}. Type: \code{boolean}. Default: \code{NA}.
\item \bold{isRequired}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isMultiline}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isInvalid}. Type: \code{boolean}. Default: \code{false}.
\item \bold{validationState}. Type: \code{valid OR invalid}. Default: \code{NA}.
\item \bold{showScrollIndicators}. Type: \code{boolean}. Default: \code{true}.
\item \bold{autoFocus}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disallowEmptySelection}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{true}.
\item \bold{disableSelectorIconRotation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{hideEmptyContent}. Type: \code{boolean}. Default: \code{false}.
\item \bold{popoverProps}. Type: \code{PopoverProps}. Default: \code{NA}.
\item \bold{listboxProps}. Type: \code{ListboxProps}. Default: \code{NA}.
\item \bold{scrollShadowProps}. Type: \code{ScrollShadowProps}. Default: \code{NA}.
\item \bold{classNames}. Type: \code{Partial<Record<"base"OR "label"OR "trigger"OR "mainWrapper" OR "innerWrapper"OR "selectorIcon" OR "value" OR "listboxWrapper"OR "listbox" OR "popoverContent" OR "helperWrapper" OR "description" OR "errorMessage", string>>}. Default: \code{NA}.
}
\item Select Events
\itemize{
\item \bold{onClose}. Type: \code{() => void}. Default: \code{NA}.
\item \bold{onOpenChange}. Type: \code{(isOpen: boolean) => void}. Default: \code{NA}.
\item \bold{onSelectionChange}. Type: \code{(keys: "all" OR Set<React.Key> & {anchorKey?: string; currentKey?: string}) => void}. Default: \code{NA}.
\item \bold{onChange}. Type: \code{React.ChangeEvent<HTMLSelectElement>}. Default: \code{NA}.
\item \bold{renderValue}. Type: \code{RenderValueFunction}. Default: \code{NA}.
}
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

animals <- list(
  list(
    label = "Bulbasaur",
    value = "bulbasaur",
    description = "Blabla",
    avatar = "https://raw.githubusercontent.com/PokeAPI/sprites/master/sprites/pokemon/1.png"
  ),
  list(
    label = "Pikachu",
    value = "pikachu",
    description = "Electric mouse",
    avatar = "https://raw.githubusercontent.com/PokeAPI/sprites/master/sprites/pokemon/25.png"
  )
)

select_items <- lapply(animals, function(animal) {
  select_item(
    key = animal[["value"]],
    value = animal[["value"]],
    startContent = avatar(src = animal[["avatar"]]),
    animal[["label"]]
  )
})

label_placements <- c(
  "inside",
  "outside",
  "outside-left"
)

ui <- nextui_page(
  debug_react = TRUE,
  p(class = "font-extrabold text-2xl uppercase", "Basic select"),
  action_button("update", "Update to bulbasaur?"),
  spacer(y = 2),
  action_button("toggle", "Open select"),
  spacer(y = 2),
  select_input(
    inputId = "select",
    label = "Select an pokemon",
    value = JS("['pikachu']"),
    selectionMode = "multiple",
    description = "This is a select input. You can select multiple values.",
    select_items
  ),
  textOutput("select_val"),
  spacer(y = 5),
  divider(),
  p(class = "font-extrabold text-2xl uppercase", "Variants"),
  lapply(select_variants, function(variant) {
    tagList(
      select_input(
        inputId = sprintf("select-\%s", variant),
        label = "Select a pokemon",
        variant = variant,
        value = JS("['pikachu']"),
        description = sprintf("This is a select input with \%s variant style", variant),
        select_items
      ),
      spacer(y = 2)
    )
  }),
  spacer(y = 5),
  divider(),
  p(
    class = "font-extrabold text-2xl uppercase",
    "Label placement and validation (no value specified)"
  ),
  lapply(label_placements, function(placement) {
    tagList(
      select_input(
        inputId = sprintf("select-\%s", placement),
        label = "Select a pokemon",
        labelPlacement = placement,
        description = sprintf("This is a select input with \%s label placement", placement),
        select_items
      ),
      spacer(y = 10)
    )
  }),
  spacer(y = 5),
  divider(),
  p(
    class = "font-extrabold text-2xl uppercase",
    "Custom render value"
  ),
  select_input(
    inputId = "customselect",
    labelPlacement = "outside-left",
    label = "Pokemon",
    description = "This is a select input. You can select multiple values.",
    items = jsonlite::toJSON(animals),
    select_items
  )
)

server <- function(input, output, session) {
  opened <- reactiveVal(FALSE)
  observeEvent(input$update, {
    update_select_input(session, "select", value = JS("['bulbasaur']"))
  })
  observeEvent(input$toggle, {
    opened(!opened())
    update_select_input(session, "select", isOpen = opened())
  })
  output$select_val <- renderText(input$select)
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/select}.
}
