% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Skeleton.R
\name{f7Skeleton}
\alias{f7Skeleton}
\title{Framework 7 skeleton effect}
\usage{
f7Skeleton(
  target,
  effect = c("fade", "blink", "pulse"),
  duration = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{target}{CSS selector on which to apply the effect.
In general, you apply the effect on a wrapper such as a card,
such that all nested elements receive the skeleton.}

\item{effect}{Choose between "fade", "blink" or "pulse".}

\item{duration}{Effect duration. NULL by default. If you know
exactly how much time your most time consuming output takes
to render, you can pass an explicit duration. In other cases,
leave it to NULL.}

\item{session}{Shiny session object.}
}
\description{
Nice loading overlay for UI elements. You
can also set \code{skeletonsOnLoad} TRUE in the app
main options (see example) to show skeletons on load.
}
\details{
This function is expected to be called from an observeEvent,
you may also have to increase the observer priority (see example).
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyMobile)

  shinyApp(
    ui = f7Page(
      title = "Skeletons",
      options = list(skeletonsOnLoad = TRUE),
      f7SingleLayout(
        navbar = f7Navbar(title = "f7Skeleton"),
        f7Block(
          f7Button("update", "Update card")
        ),
        f7Card(
          title = "Card header",
          textOutput("test"),
        ),
        f7List(
          f7ListItem(
            href = "https://www.google.com",
            title = "Item 1"
          ),
          f7ListItem(
            href = "https://www.google.com",
            title = "Item 2"
          )
        )
      )
    ),
    server = function(input, output, session) {
      txt <- eventReactive(input$update,
        {
          Sys.sleep(3)
          "This is a simple card with plain text,
        but cards can also contain their own header,
        footer, list view, image, or any other element."
        },
        ignoreNULL = FALSE
      )
      output$test <- renderText(txt())
      observeEvent(input$update,
        {
          f7Skeleton(".card", "fade")
        },
        priority = 1000
      )
    }
  )
}
}
