% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lottie_removeEventListener.R
\name{lottie_removeEventListener}
\alias{lottie_removeEventListener}
\title{Remove Event Listener from 'Lottie' Animation}
\usage{
lottie_removeEventListener(
  name,
  event,
  target,
  functionName = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{name}{A character string specifying the name of the 'Lottie' animation.}

\item{event}{The event to listen for (e.g. "\code{mouseenter}", "\code{mouseleave}" etc.).}

\item{target}{The target for the event listener, either \code{"animation"} or \code{"container"}.}

\item{functionName}{Optional name of the event handler function to remove. Should only be used if a \code{functionName} was specified when calling \code{\link{lottie_addEventListener}}.}

\item{session}{The 'shiny' session object. Defaults to the current reactive domain.}
}
\value{
This function is called for a side effect, and so there is no return value.
}
\description{
Removes an event listener from a 'Lottie' animation within a 'shiny' application.
}
\details{
When run within a reactive context, sends a custom session message \code{"lottie_js_runJS"} containing the function arguments.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)
library(shinyLottie)

ui <- fluidPage(
  include_lottie(),
  # Create an 'animation' event that updates the 'playCount' input value
  # value after each loop
  lottie_animation(
    path = "shinyLottie/example.json",
    name = "my_animation"
  ) |>
    lottie_addEventListener(
      event = "loopComplete",
      target = "animation",
      custom_js = "Shiny.setInputValue('playCount',
      lottieInstances.my_animation.playCount, {priority: 'event'});"
    ),
  actionButton("removeEventListener", "Remove Event Listener")
)

server <- function(input, output, session) {
  # Notifications demonstrate that eventListener is active
  observeEvent(input$playCount, {
    showNotification(paste("Animation played", input$playCount, "times"), duration = 1)
  })

  # Removing the event listener ceases the notifications
  observeEvent(input$removeEventListener, {
    lottie_removeEventListener(name = "my_animation", event = "loopComplete",
                               target = "animation")
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
