% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/min_max_aggregator.R
\docType{class}
\name{min_max_aggregator}
\alias{min_max_aggregator}
\title{Aggregation using local minimum and maximum values.}
\format{
An \code{R6::R6Class} object
}
\description{
Divide the data into small data ranges
and find the maximum and minimum values of each.
Note that many samples may be replaced with \code{NA},
if \code{interleave_gaps = TRUE} and the original data is increased or decreased
monotonically. Use \code{min_max_ovlp_aggregator} instead in that case.
\code{n_out} must be even number.
}
\examples{
data(noise_fluct)
agg <- min_max_aggregator$new(interleave_gaps = TRUE)
d_agg <- agg$aggregate(noise_fluct$time, noise_fluct$f500, 1000)
plotly::plot_ly(x = d_agg$x, y = d_agg$y, type = "scatter", mode = "lines")

}
\section{Super class}{
\code{shinyHugePlot::aggregator} -> \code{min_max_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-min_max_aggregator-new}{\code{min_max_aggregator$new()}}
\item \href{#method-min_max_aggregator-clone}{\code{min_max_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-aggregate'><code>shinyHugePlot::aggregator$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="set_parameters"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-set_parameters'><code>shinyHugePlot::aggregator$set_parameters()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-min_max_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-min_max_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the Aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{min_max_aggregator$new(..., interleave_gaps, coef_gap, NA_position)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interleave_gaps, coef_gap, NA_position, ...}}{Arguments pass to the constructor of \code{aggregator} object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-min_max_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-min_max_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{min_max_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
