% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_stat_aggregator.R
\docType{class}
\name{custom_stat_aggregator}
\alias{custom_stat_aggregator}
\title{Aggregation which returns arbitrary statistics}
\format{
An \code{R6::R6Class} object
}
\description{
This aggregator divides the data into no-overlapping intervals
and calculate specific statistical values such as the mean.
}
\examples{
data(noise_fluct)
agg <- custom_stat_aggregator$new(y_func = mean, interleave_gaps = TRUE)
d_agg <- agg$aggregate(noise_fluct$time, noise_fluct$f500, 1000)
plotly::plot_ly(x = d_agg$x, y = d_agg$y, type = "scatter", mode = "lines")

}
\section{Super class}{
\code{shinyHugePlot::aggregator} -> \code{custom_stat_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-custom_stat_aggregator-new}{\code{custom_stat_aggregator$new()}}
\item \href{#method-custom_stat_aggregator-clone}{\code{custom_stat_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-aggregate'><code>shinyHugePlot::aggregator$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="set_parameters"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-set_parameters'><code>shinyHugePlot::aggregator$set_parameters()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-custom_stat_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-custom_stat_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the Aggregator.


Constructor of the Aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{custom_stat_aggregator$new(
  ...,
  y_func = mean,
  x_mean = TRUE,
  interleave_gaps,
  coef_gap,
  NA_position
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{y_func}}{Function.
Statistical values are calculated using this function.
By default, \code{mean}.}

\item{\code{x_mean}}{Boolean.
Whether using the mean values or not for the x values.
If not, the x values that give the specific y values are used.
E.g., if you use \code{max} as the \code{aggregation_func} and
set this argument to \code{FALSE}, x values that give the maximum
y values are used.
By default, \code{TRUE}.}

\item{\code{interleave_gaps, coef_gap, NA_position, ...}}{Arguments pass to the constructor of \code{aggregator} object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-custom_stat_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-custom_stat_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{custom_stat_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
