% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twVarSelectizeInput.R
\name{twVarSelectizeInput}
\alias{twVarSelectizeInput}
\title{Wrapper around \code{\link[shiny:varSelectInput]{shiny::varSelectizeInput()}} but allowing for more classes}
\usage{
twVarSelectizeInput(
  inputId,
  ...,
  options = NULL,
  width = NULL,
  container_class = NULL,
  label_class = NULL,
  input_class = NULL,
  label_after_input = FALSE
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{...}{Arguments passed to \code{varSelectInput()}.}

\item{options}{A list of options. See the documentation of \pkg{selectize.js}
for possible options (character option values inside \code{\link[base:AsIs]{base::I()}} will
be treated as literal JavaScript code; see \code{\link[shiny:renderDataTable]{renderDataTable()}}
for details).}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}

\item{container_class}{additional classes to be applied to the container}

\item{label_class}{additional classes to be applied to the label}

\item{input_class}{additional classes to be applied to the input element}

\item{label_after_input}{TRUE/FALSE if the label should be put after the
input box. Default is FALSE. Useful for special cases (floating labels),
c.f. 05-apply-directive example app.}
}
\value{
a list with a \code{shiny.tag} class
}
\description{
Note that the colors for the selected elements can be customized.
c.f. 05-apply-directive example app
}
\examples{
shiny::varSelectizeInput("selectize", "A Selection", mtcars)
twVarSelectizeInput("selectize", "A Selection", mtcars,
  container_class = "CONTAINER", label_class = "LABEL",
  input_class = "INPUT"
)

# basic full shiny example
library(shiny)

ui <- fluidPage(
  use_tailwind(),
  twVarSelectizeInput(
    "values", "A Selection", mtcars,
    multiple = TRUE,
    # Apply tailwind classes
    container_class = "w-48 m-4 p-2 border border-gray-200 rounded-md drop-shadow-md",
    label_class = "font-mono text-gray-600",
    input_class = "drop-shadow-lg text-gray-600 font-mono rounded-md border-amber-400"
  ),
  verbatimTextOutput("value")
)

server <- function(input, output) {
  output$value <- renderText({
    as.character(input$values)
  })
}

if (interactive()) shiny::shinyApp(ui_basic, server)
}
\seealso{
\code{\link[shiny:varSelectInput]{shiny::varSelectizeInput()}}
}
