% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwa.R
\name{pwa}
\alias{pwa}
\title{Adds PWA support. Takes care of all the support required for browsers to
recognize the application as a Progressive Web app.}
\usage{
pwa(
  domain,
  title = "My Shiny PWA",
  output = NULL,
  icon = NULL,
  color = "#000000",
  offline_template = NULL,
  offline_message = "Looks like you are offline :/"
)
}
\arguments{
\item{domain}{The base URL where the app is hosted}

\item{title}{The title of your Shiny app}

\item{output}{Relative folder where to create the service worker file.
Usually corresponds to the folder used by shiny to serve static files,
this folder must exist and is usually the www folder of your shiny project.}

\item{icon}{Icon path to be used for the app, relative to the project root.
Recommended size is 512x512px. If left NULL a default icon is provided.}

\item{color}{Color of the app. Used to color the browser
elements when the pwa is installed.}

\item{offline_template}{Path to the offline template you want to use, relative
to the project root folder. If left NULL the default template is used.}

\item{offline_message}{When using the default offline page template
defines the message to be displayed.}
}
\value{
A UI definition that can be passed to the [shinyUI] function.
}
\description{
Adds PWA support. Takes care of all the support required for browsers to
recognize the application as a Progressive Web app.
}
\note{
For additional details on progressive web apps, visit
   \url{https://developer.mozilla.org/en-US/docs/Web/Progressive_web_apps}
}
\examples{
if (interactive()){
library(shiny.pwa)
ui <- fluidPage(
  pwa("https://myapp.com", output = "www")
)
server <- function(input, output, session) {
}
shinyApp(ui, server)
}

}
