% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_small_multiples_line_plot.R
\name{draw_small_multiples_line_plot}
\alias{draw_small_multiples_line_plot}
\title{Draw Small Multiples Line Plot}
\usage{
draw_small_multiples_line_plot(
  data,
  x_axis_var,
  y_axis_var,
  grouping_var,
  faceting_var_1,
  faceting_var_2,
  plot_max_values = FALSE,
  lowest_highest_units,
  unique_color_by_group = FALSE,
  size = 0.7,
  alpha = 0.4,
  interactive = TRUE,
  analysis_desc_label = NULL,
  x_axis_label = NULL,
  y_axis_label = NULL,
  n_breaks_x_axis = 10,
  n_breaks_y_axis = 10,
  accuracy = 0.01
)
}
\arguments{
\item{data}{input dataset to be plotted (required)}

\item{x_axis_var}{variable to be plotted on x axis (required)}

\item{y_axis_var}{variable to be plotted on x axis (required)}

\item{grouping_var}{set grouping variable (required)}

\item{faceting_var_1}{Set first faceting variable (optional)}

\item{faceting_var_2}{Set second faceting variable (optional)}

\item{plot_max_values}{Highlights maximum values per group. By default, it is set to FALSE (optional)}

\item{lowest_highest_units}{takes a vector of strings corresponding to the lowest/highest units to be highlighted (optional)}

\item{unique_color_by_group}{set whether to display each group in a unique color. By default, it is set to FALSE (optional)}

\item{size}{Set line size. By default, it is set to 0.7  (optional)}

\item{alpha}{Set transparency. By default, it is set to 0.4  (optional)}

\item{interactive}{set plot interactivity. By default, it is set to TRUE (optional)}

\item{analysis_desc_label}{Label (subtitle) for analysis description. By default, it is set to NULL  (optional)}

\item{x_axis_label}{Label for x axis. By default, it is set to display x axis column name  (optional)}

\item{y_axis_label}{Label for y axis. By default, it is set to display y axis column name  (optional)}

\item{n_breaks_x_axis}{Set number of breaks on X axis. By default, it is set to 10 (optional)}

\item{n_breaks_y_axis}{Set number of breaks on Y axis. By default, it is set to 10 (optional)}

\item{accuracy}{Set number of decimal places to be displayed on X and Y axes. Examples: 0.1 - one decimal place, 0.01 - two decimal places, 0.001 - three decimal places etc. By default, it is set to 0.01 (optional)}
}
\value{
A 'ggplot' or 'plotly' object
}
\description{
Draws a Small Multiples Line Plot
}
