% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_shadowr.R
\docType{class}
\name{shadow-class}
\alias{shadow-class}
\alias{find_element}
\alias{find_element,shadow,character,missing-method}
\alias{find_element,shadow,character,webElement-method}
\alias{find_elements}
\alias{find_elements,shadow,character,missing-method}
\alias{find_elements,shadow,character,webElement-method}
\alias{get_shadow_element}
\alias{get_shadow_element,shadow,character,webElement-method}
\alias{get_all_shadow_element}
\alias{get_all_shadow_element,shadow,character,webElement-method}
\alias{get_parent_element}
\alias{get_parent_element,shadow,webElement-method}
\alias{get_sibling_element}
\alias{get_sibling_element,shadow,webElement,character-method}
\alias{get_previous_sibling_element}
\alias{get_previous_sibling_element,shadow,webElement-method}
\alias{get_next_sibling_element}
\alias{get_next_sibling_element,shadow,webElement-method}
\alias{scroll_to}
\alias{scroll_to,shadow,webElement-method}
\alias{is_checked}
\alias{is_checked,shadow,webElement-method}
\alias{is_disabled}
\alias{is_disabled,shadow,webElement-method}
\alias{is_visible}
\alias{is_visible,shadow,webElement-method}
\title{CLASS shadow}
\usage{
find_element(shadowObject, css_selector, element)

\S4method{find_element}{shadow,character,missing}(shadowObject, css_selector, element)

\S4method{find_element}{shadow,character,webElement}(shadowObject, css_selector, element)

find_elements(shadowObject, css_selector, element)

\S4method{find_elements}{shadow,character,missing}(shadowObject, css_selector, element)

\S4method{find_elements}{shadow,character,webElement}(shadowObject, css_selector, element)

get_shadow_element(shadowObject, css_selector, element)

\S4method{get_shadow_element}{shadow,character,webElement}(shadowObject, css_selector, element)

get_all_shadow_element(shadowObject, css_selector, element)

\S4method{get_all_shadow_element}{shadow,character,webElement}(shadowObject, css_selector, element)

get_parent_element(shadowObject, element)

\S4method{get_parent_element}{shadow,webElement}(shadowObject, element)

get_sibling_element(shadowObject, element, css_selector)

\S4method{get_sibling_element}{shadow,webElement,character}(shadowObject, element, css_selector)

get_previous_sibling_element(shadowObject, element)

\S4method{get_previous_sibling_element}{shadow,webElement}(shadowObject, element)

get_next_sibling_element(shadowObject, element)

\S4method{get_next_sibling_element}{shadow,webElement}(shadowObject, element)

scroll_to(shadowObject, element)

\S4method{scroll_to}{shadow,webElement}(shadowObject, element)

is_checked(shadowObject, element)

\S4method{is_checked}{shadow,webElement}(shadowObject, element)

is_disabled(shadowObject, element)

\S4method{is_disabled}{shadow,webElement}(shadowObject, element)

is_visible(shadowObject, element)

\S4method{is_visible}{shadow,webElement}(shadowObject, element)
}
\arguments{
\item{shadowObject}{the shadow class}

\item{css_selector}{selector string to find a web element}

\item{element}{a web element}
}
\value{
Depends on the method, either a \code{RSelenium::WebElement} or a \code{boolean}.
}
\description{
Selenium plugin to manage multiple levels of shadow elements on web page. Returning a \code{RSelenium::WebElement} which you can access like you used to.
}
\section{Functions}{
\itemize{
\item \code{find_element,shadow,character,missing-method}: Use this method if want single element

\item \code{find_element,shadow,character,webElement-method}: Use this if you want to find a single elements from parent object

\item \code{find_elements,shadow,character,missing-method}: Use this if you want to find all elements

\item \code{find_elements,shadow,character,webElement-method}: Use this if you want to find all elements from parent object

\item \code{get_shadow_element,shadow,character,webElement-method}: Use this if you want to find a single element from parent

\item \code{get_all_shadow_element,shadow,character,webElement-method}: Use this if you want to find all elements from parent

\item \code{get_parent_element,shadow,webElement-method}: Use this to get the parent element if web element

\item \code{get_sibling_element,shadow,webElement,character-method}: Use this to get adjacent(sibling) element

\item \code{get_previous_sibling_element,shadow,webElement-method}: Use this to get previous adjacent(sibling) element

\item \code{get_next_sibling_element,shadow,webElement-method}: Use this to get next adjacent(sibling) element

\item \code{scroll_to,shadow,webElement-method}: Use this to scroll to web element

\item \code{is_checked,shadow,webElement-method}: Use this if you want to check if checkbox is selected

\item \code{is_disabled,shadow,webElement-method}: Use this if you want to check if element is disabled

\item \code{is_visible,shadow,webElement-method}: Use this if you want to find visibility of element
}}

\section{Slots}{

\describe{
\item{\code{driver}}{The shadow class takes a Remote Driver}

\item{\code{javascript_library}}{the selenium plugin}
}}

\examples{
\dontrun{
library(shadowr)
library(RSelenium)
remDr <- RSelenium::remoteDriver(
remoteServerAddr = "host.docker.internal",
port = 4445 , browser = "chrome")
remDr$open(silent = TRUE)
remDr$navigate(url)
shadow_rd <- shadow(remDr)
element <- find_element(shadow_rd, 'paper-tab[title="Settings"]')
elements <- find_elements(shadow_rd, 'paper-tab[title="Settings"]')
element$getElementText()
library(shadowr)
library(RSelenium)
remDr <- RSelenium::remoteDriver(
remoteServerAddr = "host.docker.internal",
port = 4445 , browser = "chrome")
remDr$open(silent = TRUE)
remDr$navigate(url)
shadow_rd <- shadow(remDr)
element <- find_element(shadow_rd, 'input[title="The name of the employee"]')
elements <- find_elements(shadow_rd, 'input[title="The name of the employee"]')
element$getElementText()
library(shadowr)
library(RSelenium)
remDr <- RSelenium::remoteDriver(
 remoteServerAddr = "host.docker.internal",
port = 4445 , browser = "chrome")
remDr$open(silent = TRUE)
remDr$navigate(url)
shadow_rd <- shadow(remDr)
element <- find_element(shadow_rd, "properties-page#settingsPage>textarea#textarea")
element$getElementText()}
}
\seealso{
\url{https://github.com/ricilandolt/shadowr} for examples
}
\keyword{shadow}
