% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_sgstar.R
\name{predict_sgstar}
\alias{predict_sgstar}
\title{Predict for Seasonal GSTAR model.}
\usage{
predict_sgstar(formula, n_time)
}
\arguments{
\item{formula}{an object from the output from sgstar() function.}

\item{n_time}{number of steps ahead for which prediction is required.}
}
\value{
returns output a dataframe that shown predict value based on model, with rows as time and column that shown for each location.
}
\description{
Predicting value based on Sgstar object
}
\examples{
library(sgstar)
data("coords")
data("simulatedata")

#create weight matrix using distance inverse matrix
z<-dist(coords,method = "euclidean")
z <- as.matrix(z)

matriksd <- 1/z
matriksd[is.infinite(matriksd)] <- 0

matriksd_w <- matriksd / rowSums(as.data.frame(matriksd))


fit <- sgstar(data = simulatedata, w = matriksd_w, p = 2,ps = 1, s =4)

#predicting for 12 time ahead
predict.fit <-predict_sgstar(fit,12)
}
\references{
Setiawan, Suhartono, and Prastuti M.(2016).S GSTAR-SUR for Seasonal Spatio Temporal Data Forecasting. Malaysian Journal Of Mathematical Sciences.10.<Corpus ID :189955959>.
}
