% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sfo_stats}
\alias{sfo_stats}
\title{SFO Airport Air Landings Statistics}
\format{
A data frame with 14 variables.
\describe{
  \item{activity_period}{Activity year and month in YYYYMM format}
  \item{operating_airline}{Airline name for the aircraft operator}
  \item{operating_airline_iata_code}{The International Air Transport Association (IATA) two-letter designation for the Operating Airline}
  \item{published_airline}{Airline name that issues the ticket and books revenue for passenger activity}
  \item{published_airline_iata_code}{The International Air Transport Association (IATA) two-letter designation for the Published Airline}
  \item{geo_summary}{The flights’ classification by domestic for flights that arrived from or departed to a destination within the United States and international for destinations outside the United States}
  \item{geo_region}{ The flight origin/destination geographic region details}
  \item{landing_aircraft_type}{A designation for three types of aircraft that landed at SFO, which includes passenger aircraft, cargo-only aircraft (“freighters”), or combination aircraft (“combi”)}
  \item{aircraft_body_type}{A designation that is independent from Landing Aircraft Type, which determines whether commercial aircraft landed at SFO is a wide body-jet, narrow-body jet, regional-jet or a propeller operated aircraft}
  \item{aircraft_manufacturer}{Manufacturer name for the aircraft that landed at SFO}
  \item{aircraft_model}{Model designation of aircraft by the manufacturer}
  \item{aircraft_version}{ Variations of the Aircraft Model, also known as the “dash number”, designated by the manufacturer to segregate unique versions of the same model}
  \item{landing_count}{The number of aircraft landings associated with General and Landings Statistics attribute fields}
  \item{total_landed_weight}{The aircraft landed weight (in pounds) associated with General and Landings Statistics attribute fields}

  }
}
\source{
San Francisco data portal (DataSF) \href{https://data.sfgov.org/Transportation/Air-Traffic-Landings-Statistics/fpux-q53t}{website}.
}
\usage{
sfo_stats
}
\description{
Monthly statistics on San Francisco International Airport (SFO) landings
}
\details{
The dataset contains the monthly statistics on the air traffic landings in San Francisco International Airport (SFO)
}
\examples{
data(sfo_stats)

require(dplyr)

# Get summary of total landing and weight by geo region
# in most recent month
sfo_stats \%>\%
  filter(activity_period == max(activity_period)) \%>\%
  group_by(geo_region) \%>\%
  summarise(total_landing = sum(landing_count),
            total_weight = sum(total_landed_weight),
  .groups = "drop")


}
\keyword{SFO}
\keyword{airline}
\keyword{datasets}
\keyword{passengers}
\keyword{timeseries}
