% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{push}
\alias{push}
\title{Push Rstudio Settings}
\usage{
push(
  do_all = FALSE,
  do_addins = FALSE,
  do_editor_bindings = FALSE,
  do_rstudio_bindings = FALSE,
  progBar = NULL
)
}
\arguments{
\item{do_all}{boolean, if TRUE will push all settings to gd, overwriting them.
This param overrides the values of the other params. Default is FALSE.}

\item{do_addins, do_editor_bindings, do_rstudio_bindings}{booleans, if TRUE will
push the respective file. Default is FALSE}

\item{progBar}{function, designed to work with [progress_bar()]. Runs after
each file is pushed.}
}
\value{
nothing
}
\description{
Pushes Rstudio settings to Google Drive, without pulling. This is just a
helper function for [sync()], the main function, but can be used alone, although
this function will not do any checking, and will just override.
Because of the way [googledrive::drive_put] is built, this function reads from
the files directly.
}
\examples{
mimic_on()
  push()              # does nothing
  push(do_all = TRUE) # will push all settings to gd, overwriting them
  push(do_editor_bindings = FALSE, do_rstudio_bindings = FALSE)
  # will push only editor and rstudio bindings
mimic_off()
}
