% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived_variables.R
\name{calcDistance}
\alias{calcDistance}
\title{Calculate distance}
\usage{
calcDistance(list)
}
\arguments{
\item{list}{A list of data frames, each of which has a column for dx and dy.}
}
\value{
A list of data frames, each of which has a variable for the distance
  moved between each data recording.
}
\description{
Calculate distance moved between time steps
}
\details{
Use the dx and dy columns in the servosphere data frames to calculate the
distance moved between each time recording. If the data will be aggregated, it
is recommended to aggregate the data before running this function.
}
\examples{
 servosphere <- list(data.frame(id = rep(1, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("a", 200),
                                date = rep("2032018", 200)),
                     data.frame(id = rep(2, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("b", 200),
                                date = rep("2032018", 200)))
servosphere <- calcDistance(servosphere)
}
