% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backlinks.R
\name{sst_bl_domain_summary}
\alias{sst_bl_domain_summary}
\title{Backlinks summary}
\usage{
sst_bl_domain_summary(
  domain,
  search_type = "domain",
  return_method = "list",
  api_token = Sys.getenv("SERPSTAT_API_TOKEN")
)
}
\arguments{
\item{domain}{(required) A domain name to analyze.}

\item{search_type}{(optional) Default value is 'domain' for
domain only (site.com). See API docs for more details.}

\item{return_method}{(optional) Accepted values are 'list' (default) to
return data object as list or 'df' to return data object as data.frame.}

\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}. Default is Sys.getenv('SERPSTAT_API_TOKEN').}
}
\value{
Returns aggregated backlinks data for the domain.
}
\description{
Returns the overview of the backlinks profile for the domain.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://api-docs.serpstat.com/docs/serpstat-public-api/ylg7q8n96yjci-get-summary-v2}{here}.
}

\section{API credits consumption}{
 1 per request.
}

\examples{
\dontrun{
sst_bl_domain_summary(
  domain        = 'serpstat.com',
  search_type   = 'domain',
  return_method = 'list'
)$data
}
}
