% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semiparametric_models.R
\name{penalized_spline_model}
\alias{penalized_spline_model}
\title{Penalized Spline model}
\usage{
penalized_spline_model(
  data,
  s = "bs",
  link = "logit",
  framework = "pl",
  sp = NULL
)
}
\arguments{
\item{data}{the input data frame, must either have `age`, `pos`, `tot` column for aggregated data OR `age`, `status` for linelisting data}

\item{s}{smoothing basis to use}

\item{link}{link function to use}

\item{framework}{which approach to fit the model ("pl" for penalized likelihood framework, "glmm" for generalized linear mixed model framework)}

\item{sp}{smoothing parameter}
}
\value{
a list of class penalized_spline_model with 6 attributes
  \item{datatype}{type of datatype used for model fitting (aggregated or linelisting)}
  \item{df}{the dataframe used for fitting the model}
  \item{framework}{either pl or glmm}
  \item{info}{fitted "gam" model when framework is pl or "gamm" model when framework is glmm}
  \item{sp}{seroprevalence}
  \item{foi}{force of infection}
}
\description{
Penalized Spline model
}
\examples{
data <- parvob19_be_2001_2003
data$status <- data$seropositive
model <- penalized_spline_model(data, framework="glmm")
model$info$gam
plot(model)
}
\seealso{
[mgcv::gam()], [mgcv::gamm()] for more information the fitted gam and gamm model
}
