% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_seromodel.R
\name{summarise_seromodel}
\alias{summarise_seromodel}
\title{Summarise specified model}
\usage{
summarise_seromodel(
  seromodel,
  serosurvey,
  alpha = 0.05,
  par_loo_estimate = "elpd_loo",
  loo_estimate_digits = 1,
  central_estimate_digits = 2,
  rhat_digits = 2
)
}
\arguments{
\item{seromodel}{stan_fit object obtained from sampling a model
with \link{fit_seromodel}}

\item{serosurvey}{\describe{
\item{\code{survey_year}}{Year in which the survey took place
(only needed to plot time models)}
\item{\code{age_min}}{Floor value of the average between age_min and age_max}
\item{\code{age_max}}{The size of the sample}
\item{\code{n_sample}}{Number of samples for each age group}
\item{\code{n_seropositive}}{Number of positive samples for each age group}
}}

\item{alpha}{1 - alpha indicates the credibility level to be used}

\item{par_loo_estimate}{Name of the loo estimate to be extracted.
Available options are:
\describe{
\item{\code{"elpd_loo"}}{Expected log pointwise predictive density}
\item{\code{"p_loo"}}{Effective number of parameters}
\item{\code{"looic"}}{Leave-one-out cross-validation information criteria}
}
For additional information refer to \link[loo:loo]{loo}.}

\item{loo_estimate_digits}{Number of loo estimate digits}

\item{central_estimate_digits}{Number of central estimate digits}

\item{rhat_digits}{Number of rhat estimate digits}
}
\value{
A list summarising the specified model
\describe{
\item{\code{model_name}}{Name of the model}
\item{\code{elpd}}{elpd and its standard deviation}
\item{\code{foi}}{Estimated foi with credible interval (for 'constant' model)}
\item{\code{foi_rhat}}{foi rhat value (for 'constant' model)}
\item{\code{seroreversion_rate}}{Estimated seroreversion rate}
\item{\code{seroreversion_rate_rhat}}{Seroreversion rate rhat value}
}
}
\description{
Summarise specified model
}
\examples{
data(veev2012)
seromodel <- fit_seromodel(veev2012, iter = 100)
summarise_seromodel(seromodel, veev2012)
}
