% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/populateDBFunctions.R
\name{dbCreateSchema}
\alias{dbCreateSchema}
\title{Create a SEND schema in an open and empty database}
\usage{
dbCreateSchema(dbToken)
}
\arguments{
\item{dbToken}{Mandatory\cr
Token for the open database connection (see \code{\link{initEnvironment}}).}
}
\value{
No return value, called for side effects\cr
}
\description{
Create all the domains and variables which are described in the SEND IG
versions 3.0 and 3.1 in the database - i.e. a union of domains from the
SEND IG versions and in each domain a union of variables from the SEND IG
versions.
}
\details{
The database must be an SQLite database - no other types of databases are
supported by this function.
}
\examples{
\dontrun{
# Create an empty SQLite database and create the SEND schema
myDbToken <- initEnvironment(dbType = 'sqlite',
                             dbPath ='/mydatapath/db/send.db',
                             dbCreate = TRUE)
dbCreateSchema(myDbToken)
}
}
