% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semnova.R
\name{semnova}
\alias{semnova}
\title{Latent repeated-measures ANOVA using the LGC approach}
\usage{
semnova(
  formula,
  idesign,
  idata,
  data,
  mmodel = NULL,
  covariates = NULL,
  groups = NULL,
  append = NULL,
  icontrasts = c("contr.poly", "contr.sum"),
  verbose = FALSE,
  compound_symmetry = FALSE,
  sphericity = FALSE,
  multiv_tests = c("wilks", "wald"),
  univ_tests = c("F"),
  randomization = list(ncores = 1, nsamples = 1000),
  ...
)
}
\arguments{
\item{formula}{Formula.}

\item{idesign}{Formula. Within-subjects design formula.}

\item{idata}{Dataframe. The dataframe contains the factorial design.}

\item{data}{Dataframe. Data object to be passed to lavaan.}

\item{mmodel}{Object of class \code{mmodel}. If not provided, manifest variables from the formula object will be used.
Otherwise, use \code{create_mmodel()} to specify measurement model.}

\item{covariates}{Not implemented yet.}

\item{groups}{Not implemented yet.}

\item{append}{Character vector. Syntax that is to be appended to lavaan syntax.}

\item{icontrasts}{Character vector. Use this argument to select the type of contrasts to be used.
Default is \code{c("contr.sum", "contr.poly")} (not ordered, ordered).}

\item{verbose}{Boolean. Print details during procedure.}

\item{compound_symmetry}{Boolean. When set to TRUE, compound symmetry is assumed among
dependent variables.}

\item{sphericity}{Boolean or formula. When set to TRUE, sphericity is assumed for all effects.}

\item{multiv_tests}{Character vector. Multivariate test statistics that are to be computed.
Possible statistics are: \code{c("wilks", "wald")}. Default is \code{multiv_tests = c("wilks", "wald")}.}

\item{univ_tests}{Character vector. Univariate test statistics that are to be computed.
Possible statistics are: \code{c("F")}. Default is \code{univ_tests = NULL}.}

\item{randomization}{Not yet supported.}

\item{...}{Additional arguments to be passed to lavaan.}
}
\value{
Function returns an lgc object. Use \code{summary(object)} to print
hypotheses. Otherwise use \code{object@sem_obj} to get access to the underlying
lavaan object.
}
\description{
Function specifies an LGC model. The idata object is used to create
the contrast matrix that is passed to the \code{lgc()} function. Typical
hypotheses are specified as well.
}
\examples{

set.seed(323412431)

data("semnova_test_data", package = "semnova")

idata  <- expand.grid(A = c("A1", "A2", "A3"), B = c("B1", "B2"))

mmodel <- create_mmodel(
    A1B1 = "var1",
    A2B1 = "var2",
    A3B1 = "var3",
    A1B2 = "var4",
    A2B2 = "var5",
    A3B2 = "var6",
    lv_scaling = "referent"
)

fit_semnova <-
    semnova(
        formula = cbind(A1B1, A2B1, A3B1, A1B2, A2B2, A3B2) ~ 1,
        data = semnova_test_data,
        idata = idata,
        idesign = ~ A * B,
        mmodel = mmodel
    )

summary(fit_semnova)

}
