% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event.R, R/semnar-package.R
\name{set_event.semnar}
\alias{set_event.semnar}
\alias{set_event}
\title{Set event information in a \code{\link{semnar}} object}
\usage{
\method{set_event}{semnar}(object, event)

set_event(object, event)
}
\arguments{
\item{object}{either an object an object of class \code{\link{semnar}}.}

\item{event}{an object of class \code{\link{semnar_event}}.}
}
\value{
The \code{\link{semnar}} object supplied in \code{object}, with the event
information as in \code{event}. See the output of
\code{semnar:::get_event_variables()} for what variables are
affected.
}
\description{
Set event information in a \code{\link{semnar}} object
}
\examples{
out <- add_presentation(presenter_name = "Ioannis",
                        presenter_surname = "Kosmidis",
                        presenter_affiliation = "University of Warwick",
                        title = "A",
                        country = "UK") |>
       add_presentation(presenter_name = "Ioannis",
                        presenter_surname = "Kosmidis",
                        presenter_affiliation = "University College London",
                        title = "B") |>
       add_presentation(presenter_name = "Ioannis",
                        presenter_surname = "Kosmidis",
                        presenter_affiliation = "University College London",
                        title = "C",
                        country = "Greece", city = "Athens")
WA <- event("WA", "UK", "Lon", "Lon", NA, NA, NA, "British Library")

out
set_event(out, WA)
}
\seealso{
\code{\link[=event]{event()}} \code{\link[=get_event]{get_event()}}
}
