% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DQtest.R
\docType{methods}
\name{DQtest}
\alias{DQtest}
\alias{DQtest-class}
\alias{DQtest-methods}
\alias{DQtest,ANY-method}
\title{A regression-based test to backtest VaR models proposed by Engle and Manganelli (2004)}
\usage{
DQtest(y, VaR, VaR_level, lag = 1, lag_hit = 1, lag_var = 1)

\S4method{DQtest}{ANY}(y, VaR, VaR_level, lag = 1, lag_hit = 1, lag_var = 1)
}
\arguments{
\item{y}{The time series to apply a VaR model (a single asset rerurn or portfolio return).}

\item{VaR}{The forecast VaR.}

\item{VaR_level}{The VaR level, typically 95\% or 99\%.}

\item{lag}{The chosen lag for y.Default is 1.}

\item{lag_hit}{The chosen lag for hit. Default is 1.}

\item{lag_var}{The chosen lag for VaR forecasts. Default is 1.}
}
\description{
Typical VaR tests cannot control for the dependence of violations, i.e., violations may cluster while the overall (unconditional) average of violations is not significantly different from \eqn{\alpha = 1-VaR}. The conditional expectation should also be zero meaning that \eqn{Hit_t(\alpha)} is uncorrelated with its own past and other lagged variables (such as \eqn{r_t},
\eqn{r_t^2} or the one-step ahead forecast VaR). To test this assumption, the dynamic conditional quantile (DQ) test is used which involves the following statistic
\eqn{DQ = Hit^T X(X^T X)^{-1} X^T Hit/ \alpha(1-\alpha)}
where \eqn{X} is the matrix of explanatory variables (e.g., raw and squared past returns) and \eqn{Hit} the vector collecting \eqn{Hit_t(\alpha)}. Under the null hypothesis, Engle and Manganelli (2004) show that the proposed
statistic \eqn{DQ} follows a \eqn{\chi^2_q} where \eqn{q = rank(X)}.
}
\examples{
#VaR_level=0.95
#y=rnorm(1000,0,4)
#VaR=rep(quantile(y,1-VaR_level),length(y))
#y[c(17,18,19,20,100,101,102,103,104)]=-8
#lag=5
#DQtest(y,VaR,VaR_level,lag)
}
\references{
Engle, Robert F., and Simone Manganelli. "CAViaR: Conditional autoregressive value at risk by regression quantiles." Journal of Business & Economic Statistics 22, no. 4 (2004): 367-381.
}
