% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_processing.R
\name{transform_results}
\alias{transform_results}
\title{Format results}
\usage{
transform_results(
  fit,
  data,
  settings,
  estimate = "median",
  HPDIprob = 0.68,
  transformed = TRUE
)
}
\arguments{
\item{fit}{fitted object}

\item{data}{list with at least two named components: \code{prices} is a
multiple time series object that contains price indices for all relevant
series, \code{weights}, is a named list of time series with (nominal)
weights, the list names  correspond to the different groups, i.e.,
\code{group1, group2, subgroup1}, if present in the model}

\item{settings}{list with model setting, in the format returned by the
function \code{initialize_settings}}

\item{estimate}{character specifying the posterior estimate. Valid options
are \code{"mean"} and \code{"median"}, the default is
\code{estimate = "median"}.}

\item{HPDIprob}{probability of highest posterior density interval, the
default is \code{HPDIprob = 0.68}}

\item{transformed}{boolean indicating if the transformed series should be
used.}
}
\value{
A data frame with results in long format.
}
\description{
Formats the output series into a tibble in long format and
computes contribution series.
}
\details{
\code{data} is preferably the output of funtion \code{prepare_data}.
}
\examples{
data("data_ch")
settings <- initialize_settings()
data <- prepate_data(
  settings = settings,
  tsl = data_ch$tsl,
  tsl_n = data_ch$tsl_n
)
model <- define_ssmodel(
  settings = settings, 
  data = data
)
prior <- initialize_prior(
  model = model, 
  settings = settings
) 
\donttest{
fit <- estimate_ssmodel(
  model = model, 
  settings = settings, 
  data = data,
  prior = prior,
  R = 100
)
df <- transform_results(
  fit = fit, 
  data = data,
  estimate = "median"
)
}
}
